/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.statistics;

import fr.xebia.management.statistics.Profiled;
import fr.xebia.management.statistics.ServiceStatistics;
import fr.xebia.management.statistics.ServiceUnavailableException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.util.StringUtils;

@ManagedResource
@Aspect
public class ProfileAspect
implements InitializingBean,
DisposableBean,
BeanNameAware,
SelfNaming {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassNameStyle classNameStyle = ClassNameStyle.COMPACT_FULLY_QUALIFIED_NAME;
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private String jmxDomain = "fr.xebia";
    private MBeanExporter mbeanExporter;
    private String name;
    private ObjectName objectName;
    private ParserContext parserContext = new TemplateParserContext();
    private ConcurrentMap<Method, Expression> profiledMethodNameAsExpressionByMethod = new ConcurrentHashMap<Method, Expression>();
    private MBeanServer server;
    protected ConcurrentMap<String, ServiceStatistics> serviceStatisticsByName = new ConcurrentHashMap<String, ServiceStatistics>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ProfileAspect ajc$perSingletonInstance;

    protected static String getFullyQualifiedMethodName(String fullyQualifiedClassName, String methodName, ClassNameStyle classNameStyle) {
        StringBuilder fullyQualifiedMethodName = new StringBuilder(fullyQualifiedClassName.length() + methodName.length() + 1);
        switch (classNameStyle) {
            case FULLY_QUALIFIED_NAME: {
                fullyQualifiedMethodName.append(fullyQualifiedClassName);
                break;
            }
            case COMPACT_FULLY_QUALIFIED_NAME: {
                String[] splittedFullyQualifiedName = StringUtils.delimitedListToStringArray((String)fullyQualifiedClassName, (String)".");
                int i = 0;
                while (i < splittedFullyQualifiedName.length - 1) {
                    fullyQualifiedMethodName.append(splittedFullyQualifiedName[i].charAt(0)).append(".");
                    ++i;
                }
                fullyQualifiedMethodName.append(splittedFullyQualifiedName[splittedFullyQualifiedName.length - 1]);
                break;
            }
            case SHORT_NAME: {
                fullyQualifiedMethodName.append(StringUtils.unqualify((String)fullyQualifiedClassName));
                break;
            }
            default: {
                fullyQualifiedMethodName.append(fullyQualifiedClassName);
            }
        }
        fullyQualifiedMethodName.append(".").append(methodName);
        return fullyQualifiedMethodName.toString();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        this.mbeanExporter = new AnnotationMBeanExporter();
        this.mbeanExporter.setEnsureUniqueRuntimeObjectNames(false);
        this.mbeanExporter.setServer(this.server);
        this.mbeanExporter.setAutodetectMode(0);
        this.mbeanExporter.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        this.mbeanExporter.destroy();
    }

    public MBeanExporter getMbeanExporter() {
        return this.mbeanExporter;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            String objectNameAsString = String.valueOf(this.jmxDomain) + ":type=ProfileAspect";
            if (StringUtils.hasLength((String)this.name)) {
                objectNameAsString = String.valueOf(objectNameAsString) + ",name=" + ObjectName.quote(this.name);
            }
            this.objectName = new ObjectName(objectNameAsString);
        }
        return this.objectName;
    }

    @ManagedAttribute
    public int getRegisteredServiceStatisticsCount() {
        return this.serviceStatisticsByName.size();
    }

    @Around(value="execution(* *(..)) && @annotation(profiled)", argNames="pjp,profiled")
    public Object profileInvocation(ProceedingJoinPoint pjp, Profiled profiled) throws Throwable {
        boolean acquired;
        String serviceStatisticsName;
        ServiceStatistics serviceStatistics;
        this.logger.trace("> profileInvocation({},{}", (Object)pjp, (Object)profiled);
        MethodSignature jointPointSignature = (MethodSignature)pjp.getStaticPart().getSignature();
        Expression nameAsExpression = (Expression)this.profiledMethodNameAsExpressionByMethod.get(jointPointSignature.getMethod());
        if (nameAsExpression == null) {
            if (StringUtils.hasLength((String)profiled.name())) {
                String nameAsStringExpression = profiled.name();
                nameAsExpression = this.expressionParser.parseExpression(nameAsStringExpression, this.parserContext);
            } else {
                String fullyQualifiedMethodName = ProfileAspect.getFullyQualifiedMethodName(jointPointSignature.getDeclaringTypeName(), jointPointSignature.getName(), this.classNameStyle);
                nameAsExpression = new LiteralExpression(fullyQualifiedMethodName);
            }
        }
        if ((serviceStatistics = (ServiceStatistics)this.serviceStatisticsByName.get(serviceStatisticsName = nameAsExpression instanceof LiteralExpression ? nameAsExpression.getExpressionString() : (String)nameAsExpression.getValue((Object)new RootObject(pjp), String.class))) == null) {
            ServiceStatistics newServiceStatistics = new ServiceStatistics(new ObjectName(String.valueOf(this.jmxDomain) + ":type=ServiceStatistics,name=" + serviceStatisticsName), profiled.businessExceptionsTypes(), profiled.communicationExceptionsTypes());
            newServiceStatistics.setSlowInvocationThresholdInMillis(profiled.slowInvocationThresholdInMillis());
            newServiceStatistics.setVerySlowInvocationThresholdInMillis(profiled.verySlowInvocationThresholdInMillis());
            int maxActive = StringUtils.hasLength((String)profiled.maxActiveExpression()) ? ((Integer)this.expressionParser.parseExpression(profiled.maxActiveExpression(), this.parserContext).getValue((Object)new RootObject(pjp), Integer.class)).intValue() : profiled.maxActive();
            newServiceStatistics.setMaxActive(maxActive);
            newServiceStatistics.setMaxActiveSemaphoreAcquisitionMaxTimeInNanos(profiled.maxActiveSemaphoreAcquisitionMaxTimeInMillis());
            ServiceStatistics previousServiceStatistics = this.serviceStatisticsByName.putIfAbsent(serviceStatisticsName, newServiceStatistics);
            if (previousServiceStatistics == null) {
                serviceStatistics = newServiceStatistics;
                this.mbeanExporter.registerManagedResource((Object)serviceStatistics);
            } else {
                serviceStatistics = previousServiceStatistics;
            }
        }
        long nanosBefore = System.nanoTime();
        Semaphore semaphore = serviceStatistics.getMaxActiveSemaphore();
        if (semaphore != null && !(acquired = semaphore.tryAcquire(serviceStatistics.getMaxActiveSemaphoreAcquisitionMaxTimeInNanos(), TimeUnit.NANOSECONDS))) {
            serviceStatistics.incrementServiceUnavailableExceptionCount();
            throw new ServiceUnavailableException("Service '" + serviceStatisticsName + "' is unavailable: " + serviceStatistics.getCurrentActive() + " invocations of are currently running");
        }
        serviceStatistics.incrementCurrentActiveCount();
        try {
            Object returned;
            Object object = returned = pjp.proceed();
            return object;
        }
        catch (Throwable t) {
            serviceStatistics.incrementExceptionCount(t);
            throw t;
        }
        finally {
            if (semaphore != null) {
                semaphore.release();
            }
            serviceStatistics.decrementCurrentActiveCount();
            long deltaInNanos = System.nanoTime() - nanosBefore;
            serviceStatistics.incrementInvocationCounterAndTotalDurationWithNanos(deltaInNanos);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("< profileInvocation({}): {}ns", (Object)serviceStatisticsName, (Object)deltaInNanos);
            }
        }
    }

    public void setBeanName(String beanName) {
        this.name = beanName;
    }

    public void setClassNameStyle(ClassNameStyle classNameStyle) {
        this.classNameStyle = classNameStyle;
    }

    public void setClassNameStyle(String classNameStyle) {
        this.classNameStyle = ClassNameStyle.valueOf(classNameStyle);
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public static ProfileAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("fr.xebia.management.statistics.ProfileAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ProfileAspect.ajc$perSingletonInstance = new ProfileAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static enum ClassNameStyle {
        COMPACT_FULLY_QUALIFIED_NAME,
        FULLY_QUALIFIED_NAME,
        SHORT_NAME;

    }

    protected static final class RootObject {
        private final ProceedingJoinPoint pjp;

        private RootObject(ProceedingJoinPoint pjp) {
            this.pjp = pjp;
        }

        public Object[] getArgs() {
            return this.pjp.getArgs();
        }

        public Object getInvokedObject() {
            return this.pjp.getThis();
        }

        public Properties getSystemProperties() {
            return System.getProperties();
        }
    }
}

