/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.statistics;

import fr.xebia.management.statistics.ServiceUnavailableException;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.core.style.ToStringCreator;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.jmx.support.MetricType;

@ManagedResource
public class ServiceStatistics
implements SelfNaming {
    private final AtomicInteger businessExceptionCounter = new AtomicInteger();
    private Class<?>[] businessExceptionsTypes;
    private final AtomicInteger communicationExceptionCounter = new AtomicInteger();
    private Class<?>[] communicationExceptionsTypes;
    private final AtomicInteger currentActiveCounter = new AtomicInteger();
    private final AtomicInteger invocationCounter = new AtomicInteger();
    private Semaphore maxActiveSemaphore;
    private long maxActiveSemaphoreAcquisitionMaxTimeInNanos;
    private final ObjectName objectName;
    private final AtomicInteger otherExceptionCounter = new AtomicInteger();
    private final AtomicInteger serviceUnavailableExceptionCounter = new AtomicInteger();
    private final AtomicInteger slowInvocationCounter = new AtomicInteger();
    private long slowInvocationThresholdInNanos;
    private final AtomicLong totalDurationInNanosCounter = new AtomicLong();
    private final AtomicInteger verySlowInvocationCounter = new AtomicInteger();
    private long verySlowInvocationThresholdInNanos;

    public static boolean containsThrowableOfType(Throwable throwable, Class<?> ... throwableTypes) {
        ArrayList<Throwable> alreadyProcessedThrowables = new ArrayList<Throwable>();
        while (throwable != null) {
            if (alreadyProcessedThrowables.contains(throwable)) {
                return false;
            }
            Class<?>[] classArray = throwableTypes;
            int n = throwableTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> throwableType = classArray[n2];
                if (throwableType.isAssignableFrom(throwable.getClass())) {
                    return true;
                }
                ++n2;
            }
            alreadyProcessedThrowables.add(throwable);
            throwable = throwable.getCause();
        }
        return false;
    }

    public ServiceStatistics(ObjectName objectName, Class<?>[] businessExceptionsTypes, Class<?>[] communicationExceptionsTypes) {
        this.objectName = objectName;
        this.businessExceptionsTypes = (Class[])businessExceptionsTypes.clone();
        this.communicationExceptionsTypes = (Class[])communicationExceptionsTypes.clone();
    }

    public ServiceStatistics(String name, Class<?>[] businessExceptionsTypes, Class<?>[] communicationExceptionsTypes) throws MalformedObjectNameException {
        this(new ObjectName("fr.xebia:type=ServiceStatistics,name=" + name), businessExceptionsTypes, communicationExceptionsTypes);
    }

    public void decrementCurrentActiveCount() {
        this.currentActiveCounter.decrementAndGet();
    }

    @ManagedMetric(description="Number of business exceptions", metricType=MetricType.COUNTER, category="throughput")
    public int getBusinessExceptionCount() {
        return this.businessExceptionCounter.get();
    }

    @ManagedMetric(description="Number of communication exceptions (timeout, connection refused, etc)", metricType=MetricType.COUNTER, category="throughput")
    public int getCommunicationExceptionCount() {
        return this.communicationExceptionCounter.get();
    }

    @ManagedMetric(description="Number of currently active invocations", metricType=MetricType.GAUGE, category="utilization")
    public int getCurrentActive() {
        return this.currentActiveCounter.get();
    }

    @ManagedMetric(description="Number of invocations", metricType=MetricType.COUNTER, category="throughput")
    public int getInvocationCount() {
        return this.invocationCounter.get();
    }

    @ManagedAttribute(description="Max active connections or -1 if max active invocation is disabled. Can be slightly inacurrate")
    public int getMaxActive() {
        if (this.maxActiveSemaphore == null) {
            return -1;
        }
        return this.maxActiveSemaphore.availablePermits() + this.getCurrentActive();
    }

    @ManagedMetric(description="Number of available additional active request", category="dynamic")
    public int getMaxActiveAvailablePermits() {
        if (this.maxActiveSemaphore == null) {
            return -1;
        }
        return this.maxActiveSemaphore.availablePermits();
    }

    public Semaphore getMaxActiveSemaphore() {
        return this.maxActiveSemaphore;
    }

    public long getMaxActiveSemaphoreAcquisitionMaxTimeInNanos() {
        return this.maxActiveSemaphoreAcquisitionMaxTimeInNanos;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.objectName;
    }

    @ManagedMetric(description="Number of non business exceptions excluding communication exceptions", metricType=MetricType.COUNTER, category="throughput")
    public int getOtherExceptionCount() {
        return this.otherExceptionCounter.get();
    }

    @ManagedMetric(description="Total Number of non business exceptions", metricType=MetricType.COUNTER, category="throughput")
    public int getTotalExceptionCount() {
        return this.getBusinessExceptionCount() + this.getCommunicationExceptionCount() + this.getOtherExceptionCount() + this.getServiceUnavailableExceptionCount();
    }

    public AtomicInteger getOtherExceptionCounter() {
        return this.otherExceptionCounter;
    }

    @ManagedAttribute(description="Max acquisition duration fur the max active semaphore")
    public long getSemaphoreAcquisitionMaxTimeInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.maxActiveSemaphoreAcquisitionMaxTimeInNanos, TimeUnit.NANOSECONDS);
    }

    @ManagedMetric(description="Number of slow 'service unavailable' exceptions", metricType=MetricType.COUNTER, category="throughput")
    public int getServiceUnavailableExceptionCount() {
        return this.serviceUnavailableExceptionCounter.get();
    }

    @ManagedMetric(description="Number of slow invocations", metricType=MetricType.COUNTER, category="throughput")
    public int getSlowInvocationCount() {
        return this.slowInvocationCounter.get();
    }

    @ManagedAttribute
    public long getSlowInvocationThresholdInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.slowInvocationThresholdInNanos, TimeUnit.NANOSECONDS);
    }

    public long getSlowInvocationThresholdInNanos() {
        return this.slowInvocationThresholdInNanos;
    }

    @ManagedAttribute(description="Total durations in millis of the invocations")
    public long getTotalDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getTotalDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @ManagedMetric(description="Total durations in nanos of the invocations", metricType=MetricType.COUNTER, unit="ns", category="throughput")
    public long getTotalDurationInNanos() {
        return this.totalDurationInNanosCounter.get();
    }

    public AtomicLong getTotalDurationInNanosCounter() {
        return this.totalDurationInNanosCounter;
    }

    @ManagedMetric(description="Number of very slow invocations", metricType=MetricType.COUNTER, category="throughput")
    public int getVerySlowInvocationCount() {
        return this.verySlowInvocationCounter.get();
    }

    @ManagedAttribute
    public long getVerySlowInvocationThresholdInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.verySlowInvocationThresholdInNanos, TimeUnit.NANOSECONDS);
    }

    public long getVerySlowInvocationThresholdInNanos() {
        return this.verySlowInvocationThresholdInNanos;
    }

    public void incrementBusinessExceptionCount() {
        this.communicationExceptionCounter.incrementAndGet();
    }

    public void incrementCommunicationExceptionCount() {
        this.businessExceptionCounter.incrementAndGet();
    }

    public void incrementCurrentActiveCount() {
        this.currentActiveCounter.incrementAndGet();
    }

    public void incrementExceptionCount(Throwable throwable) {
        if (throwable instanceof ServiceUnavailableException) {
            this.serviceUnavailableExceptionCounter.incrementAndGet();
        } else if (ServiceStatistics.containsThrowableOfType(throwable, this.communicationExceptionsTypes)) {
            this.communicationExceptionCounter.incrementAndGet();
        } else if (ServiceStatistics.containsThrowableOfType(throwable, this.businessExceptionsTypes)) {
            this.businessExceptionCounter.incrementAndGet();
        } else {
            this.otherExceptionCounter.incrementAndGet();
        }
    }

    public void incrementInvocationCount() {
        this.invocationCounter.incrementAndGet();
    }

    public void incrementInvocationCounterAndTotalDurationWithNanos(long deltaInNanos) {
        this.totalDurationInNanosCounter.addAndGet(deltaInNanos);
        this.invocationCounter.incrementAndGet();
        if (deltaInNanos >= this.verySlowInvocationThresholdInNanos) {
            this.verySlowInvocationCounter.incrementAndGet();
        } else if (deltaInNanos >= this.slowInvocationThresholdInNanos) {
            this.slowInvocationCounter.incrementAndGet();
        }
    }

    public void incrementOtherExceptionCount() {
        this.otherExceptionCounter.incrementAndGet();
    }

    public void incrementServiceUnavailableExceptionCount() {
        this.serviceUnavailableExceptionCounter.incrementAndGet();
    }

    public void incrementTotalDurationWithMillis(long deltaInMillis) {
        this.incrementTotalDurationWithNanos(TimeUnit.NANOSECONDS.convert(deltaInMillis, TimeUnit.MILLISECONDS));
    }

    public void incrementTotalDurationWithNanos(long deltaInNanos) {
        this.totalDurationInNanosCounter.addAndGet(deltaInNanos);
    }

    public void setBusinessExceptionsTypes(Class<?>[] businessExceptionsTypes) {
        this.businessExceptionsTypes = (Class[])businessExceptionsTypes.clone();
    }

    public void setCommunicationExceptionsTypes(Class<?>[] communicationExceptionsTypes) {
        this.communicationExceptionsTypes = (Class[])communicationExceptionsTypes.clone();
    }

    @ManagedAttribute
    public void setMaxActive(int maxActive) {
        this.maxActiveSemaphore = maxActive > 0 ? new Semaphore(maxActive) : null;
    }

    public void setMaxActiveSemaphoreAcquisitionMaxTimeInNanos(long semaphoreAcquisitionMaxTimeInNanos) {
        this.maxActiveSemaphoreAcquisitionMaxTimeInNanos = semaphoreAcquisitionMaxTimeInNanos;
    }

    @ManagedAttribute(description="Max acquisition duration fur the max active semaphore")
    public void setSemaphoreAcquisitionMaxTimeInMillis(long semaphoreAcquisitionMaxTimeInMillis) {
        this.maxActiveSemaphoreAcquisitionMaxTimeInNanos = TimeUnit.NANOSECONDS.convert(this.maxActiveSemaphoreAcquisitionMaxTimeInNanos, TimeUnit.MILLISECONDS);
    }

    @ManagedAttribute
    public void setSlowInvocationThresholdInMillis(long slowInvocationThresholdInMillis) {
        this.slowInvocationThresholdInNanos = TimeUnit.NANOSECONDS.convert(slowInvocationThresholdInMillis, TimeUnit.MILLISECONDS);
    }

    public void setSlowInvocationThresholdInNanos(long slowInvocationThresholdInNanos) {
        this.slowInvocationThresholdInNanos = slowInvocationThresholdInNanos;
    }

    @ManagedAttribute
    public void setVerySlowInvocationThresholdInMillis(long verySlowInvocationThresholdInMillis) {
        this.verySlowInvocationThresholdInNanos = TimeUnit.NANOSECONDS.convert(verySlowInvocationThresholdInMillis, TimeUnit.MILLISECONDS);
    }

    public void setVerySlowInvocationThresholdInNanos(long verySlowInvocationThresholdInNanos) {
        this.verySlowInvocationThresholdInNanos = verySlowInvocationThresholdInNanos;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("objectName", (Object)this.objectName).append("slowInvocationThresholdInMillis", this.getSlowInvocationThresholdInMillis()).append("verySlowInvocationThresholdInMillis", this.getVerySlowInvocationThresholdInMillis()).append("communicationExceptionsTypes", this.communicationExceptionsTypes).append("businessExceptionsTypes", this.businessExceptionsTypes).append("invocationCount", (Object)this.invocationCounter).append("maxActiveAvailablePermits", this.getMaxActiveAvailablePermits()).append("totalDurationInMillis", this.getTotalDurationInMillis()).toString();
    }
}

