/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.springframework.concurrent;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.style.ToStringCreator;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ThreadPoolExecutorFactory
extends AbstractFactoryBean<ThreadPoolExecutor>
implements FactoryBean<ThreadPoolExecutor>,
BeanNameAware {
    private String beanName;
    private int corePoolSize = 1;
    private long keepAliveTimeInSeconds;
    private int maximumPoolSize = Integer.MAX_VALUE;
    private int queueCapacity = Integer.MAX_VALUE;
    private Class<? extends RejectedExecutionHandler> rejectedExecutionHandlerClass = ThreadPoolExecutor.AbortPolicy.class;

    protected ThreadPoolExecutor createInstance() throws Exception {
        Assert.isTrue((this.corePoolSize >= 0 ? 1 : 0) != 0, (String)"corePoolSize must be greater than or equal to zero");
        Assert.isTrue((this.maximumPoolSize > 0 ? 1 : 0) != 0, (String)"maximumPoolSize must be greater than zero");
        Assert.isTrue((this.maximumPoolSize >= this.corePoolSize ? 1 : 0) != 0, (String)"maximumPoolSize must be greater than or equal to corePoolSize");
        Assert.isTrue((this.queueCapacity >= 0 ? 1 : 0) != 0, (String)"queueCapacity must be greater than or equal to zero");
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(String.valueOf(this.beanName) + "-");
        threadFactory.setDaemon(true);
        AbstractQueue blockingQueue = this.queueCapacity == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(this.queueCapacity);
        SpringJmxEnabledThreadPoolExecutor instance = new SpringJmxEnabledThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeInSeconds, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)blockingQueue), (ThreadFactory)threadFactory, this.rejectedExecutionHandlerClass.newInstance(), new ObjectName("java.util.concurrent:type=ThreadPoolExecutor,name=" + this.beanName));
        return instance;
    }

    protected void destroyInstance(ThreadPoolExecutor instance) throws Exception {
        instance.shutdown();
    }

    public Class<?> getObjectType() {
        return SpringJmxEnabledThreadPoolExecutor.class;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setKeepAliveTimeInSeconds(long keepAliveTimeInSeconds) {
        this.keepAliveTimeInSeconds = keepAliveTimeInSeconds;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    @Deprecated
    public void setNbThreads(int nbThreads) {
        this.corePoolSize = nbThreads;
        this.maximumPoolSize = nbThreads;
    }

    public void setPoolSize(String poolSize) {
        if (!StringUtils.hasText((String)poolSize)) {
            return;
        }
        switch (StringUtils.countOccurrencesOf((String)poolSize, (String)"-")) {
            case 0: {
                this.maximumPoolSize = this.corePoolSize = Integer.parseInt(poolSize);
                break;
            }
            case 1: {
                String[] splittedPoolSize = StringUtils.split((String)poolSize, (String)"-");
                this.corePoolSize = Integer.parseInt(splittedPoolSize[0]);
                this.maximumPoolSize = Integer.parseInt(splittedPoolSize[1]);
                break;
            }
            default: {
                throw new BeanCreationException(this.beanName, "Invalid pool-size value [" + poolSize + "]: only single maximum integer " + "(e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported.");
            }
        }
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setRejectedExecutionHandlerClass(Class<? extends RejectedExecutionHandler> rejectedExecutionHandlerClass) {
        this.rejectedExecutionHandlerClass = rejectedExecutionHandlerClass;
    }

    private static class CountingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final AtomicInteger rejectedExecutionCount = new AtomicInteger();
        private final RejectedExecutionHandler rejectedExecutionHandler;

        public CountingRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
        }

        public int getRejectedExecutionCount() {
            return this.rejectedExecutionCount.get();
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            this.rejectedExecutionCount.incrementAndGet();
            this.rejectedExecutionHandler.rejectedExecution(r, executor);
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("rejectedExecutionCount", (Object)this.rejectedExecutionCount).append("rejectedExecutionHandler", (Object)this.rejectedExecutionHandler).toString();
        }
    }

    @ManagedResource
    public static class SpringJmxEnabledThreadPoolExecutor
    extends ThreadPoolExecutor
    implements SelfNaming {
        private ObjectName objectName;

        public SpringJmxEnabledThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler, ObjectName objectName) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new CountingRejectedExecutionHandler(rejectedExecutionHandler));
            this.objectName = objectName;
        }

        @Override
        @ManagedAttribute(description="Returns the approximate number of threads that are actively executing tasks")
        public int getActiveCount() {
            return super.getActiveCount();
        }

        @Override
        @ManagedAttribute(description="Returns the approximate total number of tasks that have completed execution.")
        public long getCompletedTaskCount() {
            return super.getCompletedTaskCount();
        }

        @Override
        @ManagedAttribute(description="Returns the core number of threads")
        public int getCorePoolSize() {
            return super.getCorePoolSize();
        }

        @Override
        @ManagedAttribute(description="Returns the largest number of threads that have ever simultaneously been in the pool.")
        public int getLargestPoolSize() {
            return super.getLargestPoolSize();
        }

        @Override
        @ManagedAttribute(description="Returns the maximum allowed number of threads")
        public int getMaximumPoolSize() {
            return super.getMaximumPoolSize();
        }

        public ObjectName getObjectName() throws MalformedObjectNameException {
            return this.objectName;
        }

        @ManagedAttribute(description="Returns the number of additional elements that this queue can ideally (in the absence of memory or resource constraints) accept without  blocking, or Integer.MAX_VALUE if there is no intrinsic limit.")
        public int getQueueRemainingCapacity() {
            return this.getQueue().remainingCapacity();
        }

        @ManagedAttribute(description="Returns the number of tasks that has ever been rejected")
        public int getRejectedExecutionCount() {
            return ((CountingRejectedExecutionHandler)this.getRejectedExecutionHandler()).getRejectedExecutionCount();
        }

        @Override
        @ManagedAttribute(description="Returns the approximate total number of tasks that have ever been scheduled for execution (does not include the rejected tasks)")
        public long getTaskCount() {
            return super.getTaskCount();
        }

        @Override
        @ManagedAttribute(description="Sets the core number of threads. If the new value is smaller than the current value, excess existing threads will be terminated when they next become idle. If larger, new threads will, if needed, be started to execute any queued tasks.")
        public void setCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        @ManagedAttribute(description="Sets the maximum allowed number of threads. If the new value is smaller than the current value, excess existing threads will be terminated when they next become idle.")
        public void setMaximumPoolSize(int maximumPoolSize) {
            super.setMaximumPoolSize(maximumPoolSize);
        }

        @Override
        public String toString() {
            return new ToStringCreator((Object)this).append("objectName", (Object)this.objectName).append("corePoolSize", this.getCorePoolSize()).append("maximumPoolSize", this.getMaximumPoolSize()).append("keepAliveTimeInMillis", this.getKeepAliveTime(TimeUnit.MILLISECONDS)).append("queue", this.getQueue().getClass()).append("rejectedExecutionHandler", (Object)this.getRejectedExecutionHandler()).toString();
        }
    }
}

