/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.springframework.jms;

import fr.xebia.springframework.jms.ManagedDefaultMessageListenerContainerMBean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jmx.export.naming.SelfNaming;

public class ManagedDefaultMessageListenerContainer
extends DefaultMessageListenerContainer
implements ManagedDefaultMessageListenerContainerMBean,
BeanNameAware,
SelfNaming {
    private ObjectName objectName;

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            String destinationName = this.getDestinationName();
            Destination destination = this.getDestination();
            if (destinationName == null && destination != null) {
                try {
                    if (destination instanceof Queue) {
                        Queue queue = (Queue)destination;
                        destinationName = queue.getQueueName();
                    } else if (destination instanceof Topic) {
                        Topic topic = (Topic)destination;
                        destinationName = topic.getTopicName();
                    }
                }
                catch (JMSException e) {
                    throw new UncategorizedJmsException((Throwable)e);
                }
            }
            this.objectName = ObjectName.getInstance("javax.jms:type=MessageListenerContainer,name=" + ObjectName.quote(this.getBeanName()) + ",destination=" + destinationName);
        }
        return this.objectName;
    }
}

