package fr.zebasto.spring.identity.defaults.configuration;

import fr.zebasto.spring.post.initialize.config.EnablePostInitialize;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 *
 */
@EnablePostInitialize
@EnableTransactionManagement
@Configuration(value = "identity")
@EntityScan(value = "fr.zebasto.spring.identity.defaults.model")
@ComponentScan(basePackages = "fr.zebasto.spring.identity.defaults")
@EnableJpaRepositories(basePackages = "fr.zebasto.spring.identity.defaults.repository")
public class IdentityDefaultsConfiguration {
    @Value("${identity.security.pfx}")
    public String pfx = "PERMISSION";

    @Value("${identity.security.target.users}")
    public String users = "USER";

    @Value("${identity.security.target.groups}")
    public String groups = "GROUP";

    @Value("${identity.security.target.roles}")
    public String roles = "ROLE";

    @Value("${identity.security.target.applications}")
    public String applications = "APPLICATION";

    @Value("${identity.security.target.permissions}")
    public String permissions = "PERMISSION";

    @Value("${identity.security.target.actions}")
    public String actions = "ACTIONS";

    @Value("${identity.security.actions.update}")
    public String create = "CREATE";

    @Value("${identity.security.actions.read}")
    public String read = "READ";

    @Value("${identity.security.actions.update}")
    public String update = "UPDATE";

    @Value("${identity.security.actions.delete}")
    public String delete = "DELETE";
}
