package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.configuration.IdentityRoles;
import fr.zebasto.spring.identity.defaults.model.DefaultAction;
import fr.zebasto.spring.identity.defaults.repository.DefaultActionRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.ReflectionUtils;

import javax.inject.Inject;
import javax.inject.Named;
import java.lang.reflect.Field;

/**
 *
 */
@Named("actionInitializer")
@Profile({"identity-data", "identity-data-action"})
public class ActionInitializer {

    @Inject
    @Named("actionRepository")
    private DefaultActionRepository actionRepository;

    @PostInitialize(order = 1)
    public void initializeData() {
        ReflectionUtils.doWithFields(IdentityRoles.Actions.class, new ReflectionUtils.FieldCallback() {
            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                actionRepository.save(new DefaultAction(field.getName()));
            }
        }, new ReflectionUtils.FieldFilter() {
            @Override
            public boolean matches(Field field) {
                return !field.getName().contains("this") && actionRepository.findByName(field.getName()) == null;
            }
        });
    }
}
