package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.configuration.IdentityRoles;
import fr.zebasto.spring.identity.defaults.model.DefaultApplication;
import fr.zebasto.spring.identity.defaults.repository.DefaultApplicationRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import org.springframework.context.annotation.Profile;
import org.springframework.util.ReflectionUtils;

import javax.inject.Inject;
import javax.inject.Named;
import java.lang.reflect.Field;

/**
 *
 */
@Named("applicationInitializer")
@Profile({"identity-data", "identity-data-application"})
public class ApplicationInitializer {

    @Inject
    @Named("applicationRepository")
    private DefaultApplicationRepository applicationRepository;

    @PostInitialize(order = 1)
    public void initializeData() {
        ReflectionUtils.doWithFields(IdentityRoles.Applications.class, new ReflectionUtils.FieldCallback() {
            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                applicationRepository.save(new DefaultApplication(field.getName()));
            }
        }, new ReflectionUtils.FieldFilter() {
            @Override
            public boolean matches(Field field) {
                return !field.getName().contains("this") && applicationRepository.findByName(field.getName()) == null;
            }
        });
    }
}
