package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.model.DefaultGroup;
import fr.zebasto.spring.identity.defaults.repository.DefaultGroupRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultRoleRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultUserRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import org.springframework.context.annotation.Profile;

import javax.inject.Inject;
import javax.inject.Named;

/**
 * Class description
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("groupInitializer")
@Profile({"identity-data", "identity-data-group"})
public class GroupInitializer {
    @Inject
    @Named("groupRepository")
    private DefaultGroupRepository groupRepository;

    @Inject
    @Named("roleRepository")
    private DefaultRoleRepository roleRepository;

    @Inject
    @Named("userRepository")
    private DefaultUserRepository userRepository;

    @PostInitialize(order = 4)
    public void initializeData() {
        DefaultGroup demoGroup = new DefaultGroup();
        demoGroup.setName("Demo Group");
        demoGroup.getUsers().addAll(userRepository.findAll());
        demoGroup.getRoles().add(roleRepository.findByName("Role Read ALL"));
        groupRepository.save(demoGroup);

        DefaultGroup adminGroup = new DefaultGroup();
        adminGroup.setName("Admin Group");
        adminGroup.getGroups().add(demoGroup);
        adminGroup.getUsers().addAll(userRepository.findByLogin("admin"));
        adminGroup.getRoles().add(roleRepository.findByName("Role Create ALL"));
        adminGroup.getRoles().add(roleRepository.findByName("Role Update ALL"));
        adminGroup.getRoles().add(roleRepository.findByName("Role Delete ALL"));
        groupRepository.save(adminGroup);
    }
}
