package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.configuration.IdentityRoles;
import fr.zebasto.spring.identity.defaults.model.DefaultAction;
import fr.zebasto.spring.identity.defaults.model.DefaultApplication;
import fr.zebasto.spring.identity.defaults.model.DefaultPermission;
import fr.zebasto.spring.identity.defaults.repository.DefaultActionRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultApplicationRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultPermissionRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import org.springframework.context.annotation.Profile;
import org.springframework.util.ReflectionUtils;

import javax.inject.Inject;
import javax.inject.Named;
import java.lang.reflect.Field;
import java.text.MessageFormat;

/**
 * Created by a528122 on 05/08/2014.
 */
@Named("permissionInitializer")
@Profile({"identity-data", "identity-data-permission"})
public class PermissionInitializer {
    @Inject
    @Named("applicationRepository")
    private DefaultApplicationRepository applicationRepository;

    @Inject
    @Named("actionRepository")
    private DefaultActionRepository actionRepository;

    @Inject
    @Named("permissionRepository")
    private DefaultPermissionRepository permissionRepository;

    private ReflectionUtils.FieldFilter filter = new ReflectionUtils.FieldFilter() {
        @Override
        public boolean matches(Field field) {
            return !field.getName().contains("this");
        }
    };

    @PostInitialize(order = 2)
    public void initializeData() {
        ReflectionUtils.doWithFields(IdentityRoles.Applications.class, new ReflectionUtils.FieldCallback() {
            @Override
            public void doWith(Field application) throws IllegalArgumentException, IllegalAccessException {
                final DefaultApplication defaultApplication = applicationRepository.findByName(application.getName());

                ReflectionUtils.doWithFields(IdentityRoles.Actions.class, new ReflectionUtils.FieldCallback() {
                    @Override
                    public void doWith(Field action) throws IllegalArgumentException, IllegalAccessException {
                        final DefaultAction defaultAction = actionRepository.findByName(action.getName());
                        permissionRepository.save(new DefaultPermission(MessageFormat.format("Auto-Created-{0}-{1}", defaultApplication.getName(), defaultAction.getName()), "Permission Auto Created by PermissionInitializer.class", defaultApplication, defaultAction));
                    }
                }, filter);
            }
        }, filter);
    }
}
