package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.model.DefaultRole;
import fr.zebasto.spring.identity.defaults.repository.DefaultPermissionRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultRoleRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import org.springframework.context.annotation.Profile;

import javax.inject.Inject;
import javax.inject.Named;

/**
 * Class description
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("roleInitializer")
@Profile({"identity-data", "identity-data-role"})
public class RoleInitializer {

    @Inject
    @Named("roleRepository")
    private DefaultRoleRepository roleRepository;

    @Inject
    @Named("permissionRepository")
    private DefaultPermissionRepository permissionRepository;

    @PostInitialize(order = 3)
    public void initializeData() {
        DefaultRole readRole = new DefaultRole();
        readRole.setName("Role Read ALL");
        readRole.getPermissions().addAll(permissionRepository.findByCodeLike("PERMISSION_READ_%"));
        this.roleRepository.save(readRole);

        DefaultRole createRole = new DefaultRole();
        createRole.setName("Role Create ALL");
        createRole.getPermissions().addAll(permissionRepository.findByCodeLike("PERMISSION_CREATE_%"));
        this.roleRepository.save(createRole);

        DefaultRole updateRole = new DefaultRole();
        updateRole.setName("Role Update ALL");
        updateRole.getPermissions().addAll(permissionRepository.findByCodeLike("PERMISSION_UPDATE_%"));
        this.roleRepository.save(updateRole);

        DefaultRole deleteRole = new DefaultRole();
        deleteRole.setName("Role Delete ALL");
        deleteRole.getPermissions().addAll(permissionRepository.findByCodeLike("PERMISSION_DELETE_%"));
        this.roleRepository.save(deleteRole);
    }
}
