package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.model.DefaultUser;
import fr.zebasto.spring.identity.defaults.repository.DefaultUserRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;

import javax.inject.Inject;
import javax.inject.Named;

/**
 * Class description
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("userInitializer")
@Profile({"identity-data", "identity-data-user"})
public class UserInitializer {
    @Inject
    @Named("userRepository")
    private DefaultUserRepository userRepository;

    @Autowired
    private PasswordEncoder passwordEncoder;

    @PostInitialize(order = 1)
    public void initializeData() {
        DefaultUser demoUser = new DefaultUser();
        demoUser.setLogin("demo");
        demoUser.setPassword(passwordEncoder.encode("demo"));
        demoUser.setEmail("demo@spring-identity.org");
        demoUser.setFirstName("Demo");
        demoUser.setLastName("Demo");
        this.userRepository.save(demoUser);

        DefaultUser adminUser = new DefaultUser();
        adminUser.setLogin("admin");
        adminUser.setPassword(passwordEncoder.encode("admin"));
        adminUser.setEmail("admin@spring-identity.org");
        adminUser.setFirstName("Admin");
        adminUser.setLastName("Admin");
        this.userRepository.save(adminUser);
    }
}
