package fr.zebasto.spring.identity.defaults.model;

import fr.zebasto.spring.identity.contract.model.Application;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotEmpty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import java.util.UUID;

/**
 *
 */
@Entity
@Table(name = "IDENTITY_APPLICATIONS")
public class DefaultApplication implements Application<UUID> {

    /**
     *
     */
    private UUID id = UUID.randomUUID();

    /**
     *
     */
    private String name;

    /**
     *
     */
    public DefaultApplication() {
    }

    /**
     *
     * @param name the name
     */
    public DefaultApplication(String name) {
        this.name = name;
    }

    /**
     * @return The id
     */
    @Id
    @Override
    @Type(type = "uuid-char")
    public UUID getId() {
        return this.id;
    }

    /**
     * @param id The id
     */
    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    /**
     * @return The name
     */
    @NotNull
    @NotEmpty
    @Override
    @Column(nullable = false, unique = true)
    public String getName() {
        return this.name;
    }

    /**
     * @param name The name
     */
    @Override
    public void setName(String name) {
        this.name = name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
    }
}
