package fr.zebasto.spring.identity.defaults.model;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import fr.zebasto.spring.identity.contract.model.Group;
import fr.zebasto.spring.identity.contract.model.Permission;
import fr.zebasto.spring.identity.contract.model.Role;
import fr.zebasto.spring.identity.contract.model.User;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotEmpty;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Describes a group.
 * A group has few attributes, a name, a list of {@link DefaultUser} belonging to this
 * Group and some permissions
 */
@Entity
@Table(name = "IDENTITY_GROUPS")
public class DefaultGroup implements Group<UUID> {

    private UUID id = UUID.randomUUID();

    /**
     * name of the group
     */
    private String name = null;

    private List<Permission> permissions = new ArrayList<Permission>();

    private List<Group> groups = new ArrayList<Group>();

    private List<User> users = new ArrayList<User>();

    private List<Role> roles = new ArrayList<Role>();

    /**
     * Default Constructor
     */
    public DefaultGroup() {

    }

    @Id
    @Override
    @Type(type = "uuid-char")
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    /**
     * getName
     *
     * @return name of the group
     */
    @NotNull
    @NotEmpty
    @Column(unique = true)
    public String getName() {
        return name;
    }

    /**
     * setName
     *
     * @param name the name to be set for the group
     */
    public void setName(String name) {
        this.name = name;
    }

    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultPermission.class)
    @JoinTable(name = "IDENTITY_MAPPING_GROUP_PERMISSION")
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultPermission.class)
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultGroup.class)
    @JoinTable(name = "IDENTITY_MAPPING_GROUP_GROUP")
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultGroup.class)
    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultUser.class)
    @JsonIgnoreProperties({"permissions", "groups", "roles"})
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultUser.class)
    @JoinTable(name = "IDENTITY_MAPPING_GROUP_USER", joinColumns = {@JoinColumn(name = "group_id")}, inverseJoinColumns = {@JoinColumn(name = "user_id")})
    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultRole.class)
    @JoinTable(name = "IDENTITY_MAPPING_GROUP_ROLE")
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultRole.class)
    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
    }
}
