package fr.zebasto.spring.identity.defaults.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import fr.zebasto.spring.identity.contract.model.Permission;
import fr.zebasto.spring.identity.contract.model.Role;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotEmpty;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 *
 */
@Entity
@Table(name = "IDENTITY_ROLES")
public class DefaultRole implements Role<UUID> {

    /**
     *
     */
    private UUID id = UUID.randomUUID();

    /**
     *
     */
    private String name;

    /**
     *
     */
    private List<Permission> permissions = new ArrayList<Permission>();

    /**
     * Hide default constructor not to be able to create roles w/o a name.
     */
    public DefaultRole() {
    }

    /**
     * @param roleName Name of the role to create.
     */
    public DefaultRole(String roleName) {
        this.setName(roleName);
    }

    /**
     * @return The id
     */
    @Id
    @Override
    @Type(type = "uuid-char")
    public UUID getId() {
        return id;
    }

    /**
     * @param id the id
     */
    public void setId(UUID id) {
        this.id = id;
    }

    /**
     * Retrieve the name of the role.
     *
     * @return the name of the role.
     */
    @Column(unique = true, nullable = false)
    @NotNull
    @NotEmpty
    public String getName() {
        return this.name;
    }

    /**
     * Change the name of the role.
     *
     * @param roleName Name of the role.
     */
    public void setName(String roleName) {
        this.name = roleName;
    }

    /**
     * Retrieve the permissions assigned to the role.
     *
     * @return the permissions assigned to the role.
     */
    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultPermission.class)
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultPermission.class)
    @JoinTable(name = "IDENTITY_MAPPING_ROLE_PERMISSION")
    public List<Permission> getPermissions() {
        return permissions;
    }

    /**
     * @param permissions the permissions
     */
    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DefaultRole other = (DefaultRole) obj;

        if ((this.id == null) ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }

        return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + (this.id == null ? 0 : this.id.hashCode());
        return hash;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
    }
}
