package fr.zebasto.spring.identity.defaults.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import fr.zebasto.spring.identity.contract.model.Group;
import fr.zebasto.spring.identity.contract.model.Permission;
import fr.zebasto.spring.identity.contract.model.Role;
import fr.zebasto.spring.identity.contract.model.User;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Describe a user account.
 * A User has some attributes such as login, password, email, ... TODO there is
 * * some fields which have in comments "Nullable=false" , this cannot be remove
 * from comments without refactoring the abstractTestRepository class
 */
@Entity
@Table(name = "IDENTITY_USERS")
public class DefaultUser implements User<UUID> {

    /**
     *
     */
    private UUID id = UUID.randomUUID();

    /**
     *
     */
    private String firstName;

    /**
     *
     */
    private String lastName;

    /**
     *
     */
    private String login;

    /**
     *
     */
    private String password;

    /**
     *
     */
    private String email;

    /**
     *
     */
    private List<Permission> permissions = new ArrayList<Permission>();

    /**
     *
     */
    private List<Group> groups = new ArrayList<Group>();

    /**
     *
     */
    private List<Role> roles = new ArrayList<Role>();

    /**
     * default Constructor
     */
    public DefaultUser() {

    }

    /**
     * @return the id
     */
    @Id
    @Override
    @Type(type = "uuid-char")
    public UUID getId() {
        return this.id;
    }

    /**
     * @param id the id
     */
    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    /**
     * getLogin
     *
     * @return the user login
     */
    @NotNull
    @NotEmpty
    @Override
    @Column(unique = true)
    public String getLogin() {
        return this.login;
    }

    /**
     * setLogin
     *
     * @param login the login to be set for the user
     */
    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    /**
     * gets the Password
     * The password can not be given in the XML/JSON representation of the user
     *
     * @return user's password
     */
    @NotNull
    @Override
    @NotEmpty
    @Column(length = 60)
    public String getPassword() {
        return password;
    }

    /**
     * sets the user's Password
     *
     * @param password ,the password to be set to the user
     */
    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the permissions
     */
    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultPermission.class)
    @JoinTable(name = "IDENTITY_MAPPING_USER_PERMISSION")
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultPermission.class)
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    /**
     * @param permissions the permissions
     */
    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    /**
     * @return the groups
     */
    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultGroup.class)
    @JsonIgnoreProperties({"permissions", "groups", "users", "roles"})
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultGroup.class)
    @JoinTable(name = "IDENTITY_MAPPING_GROUP_USER", joinColumns = {@JoinColumn(name = "user_id")}, inverseJoinColumns = {@JoinColumn(name = "group_id")})
    public List<Group> getGroups() {
        return this.groups;
    }

    /**
     * @param groups the groups
     */
    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    /**
     * @return the roles
     */
    @Override
    //@LazyCollection(LazyCollectionOption.EXTRA)
    @JsonDeserialize(contentAs = DefaultRole.class)
    @JoinTable(name = "IDENTITY_MAPPING_USER_ROLE")
    @ManyToMany(fetch = FetchType.EAGER, targetEntity = DefaultRole.class)
    public List<Role> getRoles() {
        return this.roles;
    }

    /**
     * @param roles the roles
     */
    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    /**
     * gets the user's FirstName
     *
     * @return user's FirstName
     */
    @Column
    @NotEmpty
    @NotNull
    public String getFirstName() {
        return firstName;
    }

    /**
     * sets the user's FirstName
     *
     * @param firstName the firstName to be set
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /**
     * get's the user's lastName
     *
     * @return user's lastName
     */
    @Column
    @NotEmpty
    @NotNull
    public String getLastName() {
        return lastName;
    }

    /**
     * sets the user's LastName
     *
     * @param lastName the lastName to be set
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /**
     * gets the user's Email
     *
     * @return user's email;
     */
    @Email
    @NotNull
    @Column(unique = true)
    public String getEmail() {
        return email;
    }

    /**
     * sets the user's email
     *
     * @param email the email to be set
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
    }
}
