package fr.zebasto.spring.identity.defaults.repository;

import fr.zebasto.spring.identity.core.repository.AbstractUserRepository;
import fr.zebasto.spring.identity.defaults.model.DefaultUser;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import javax.inject.Named;
import java.util.List;
import java.util.UUID;

@Named("userRepository")
public interface DefaultUserRepository extends AbstractUserRepository<DefaultUser, UUID> {
    /**
     * Gets the user of a group.
     * Override this method in order to customize @Query Spring Data annotation
     *
     * @param groupName The name of the group.
     * @return A list of users corresponding to the given group.
     */
    @Override
    @Query("SELECT DISTINCT u FROM DefaultUser u JOIN u.groups g WHERE g.name = :groupName")
    List<DefaultUser> getUsersFromGroup(@Param("groupName") String groupName);

    /**
     * Gets the user of a group.
     * Override this method in order to customize @Query Spring Data annotation
     *
     * @param role The name of the group.
     * @return A list of users corresponding to the given group.
     */
    @Override
    @Query("SELECT DISTINCT u FROM DefaultUser u JOIN u.roles r WHERE r.name = :role")
    List<DefaultUser> getUsersFromRoles(@Param("role") String role);
}
