package fr.zebasto.spring.identity.defaults.service;

import fr.zebasto.spring.identity.core.service.AbstractActionService;
import fr.zebasto.spring.identity.defaults.model.DefaultAction;
import fr.zebasto.spring.identity.defaults.repository.DefaultActionRepository;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.UUID;

/**
 * Simple Service implementation used to manage {@link DefaultAction} entity
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("actionService")
public class DefaultActionService extends AbstractActionService<DefaultAction, UUID, DefaultActionRepository> {
    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("actionRepository")
    public void setRepository(DefaultActionRepository actionRepository) {
        super.setRepository(actionRepository);
    }
}
