package fr.zebasto.spring.identity.defaults.service;

import fr.zebasto.spring.identity.core.service.AbstractApplicationService;
import fr.zebasto.spring.identity.defaults.model.DefaultApplication;
import fr.zebasto.spring.identity.defaults.repository.DefaultApplicationRepository;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.UUID;

/**
 * Simple Service implementation used to manage {@link DefaultApplication} entity
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("applicationService")
public class DefaultApplicationService extends AbstractApplicationService<DefaultApplication, UUID, DefaultApplicationRepository> {
    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("applicationRepository")
    public void setRepository(DefaultApplicationRepository applicationRepository) {
        super.setRepository(applicationRepository);
    }
}
