package fr.zebasto.spring.identity.defaults.service;

import fr.zebasto.spring.identity.contract.service.RoleService;
import fr.zebasto.spring.identity.core.service.AbstractGroupService;
import fr.zebasto.spring.identity.defaults.model.DefaultGroup;
import fr.zebasto.spring.identity.defaults.repository.DefaultGroupRepository;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.UUID;

/**
 * Simple Service implementation used to manage {@link DefaultGroup} entity
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("groupService")
public class DefaultGroupService extends AbstractGroupService<DefaultGroup, UUID, DefaultGroupRepository> {
    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("groupRepository")
    public void setRepository(DefaultGroupRepository groupRepository) {
        super.setRepository(groupRepository);
    }

    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("roleService")
    public void setRoleService(RoleService roleService) {
        super.setRoleService(roleService);
    }
}
