package fr.zebasto.spring.identity.defaults.service;

import fr.zebasto.spring.identity.core.service.AbstractPermissionService;
import fr.zebasto.spring.identity.defaults.model.DefaultPermission;
import fr.zebasto.spring.identity.defaults.repository.DefaultPermissionRepository;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.UUID;

/**
 * Simple Service implementation used to manage {@link DefaultPermission} entity
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("permissionService")
public class DefaultPermissionService extends AbstractPermissionService<DefaultPermission, UUID, DefaultPermissionRepository> {
    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("permissionRepository")
    public void setRepository(DefaultPermissionRepository permissionRepository) {
        super.setRepository(permissionRepository);
    }
}
