package fr.zebasto.spring.identity.defaults.service;

import fr.zebasto.spring.identity.core.service.AbstractRoleService;
import fr.zebasto.spring.identity.defaults.model.DefaultRole;
import fr.zebasto.spring.identity.defaults.repository.DefaultRoleRepository;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.UUID;

/**
 * Simple Service implementation used to manage {@link DefaultRole} entity
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("roleService")
public class DefaultRoleService extends AbstractRoleService<DefaultRole, UUID, DefaultRoleRepository> {
    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("roleRepository")
    public void setRepository(DefaultRoleRepository roleRepository) {
        super.setRepository(roleRepository);
    }
}
