package fr.zebasto.spring.identity.defaults.service;

import fr.zebasto.spring.identity.contract.service.ApplicationService;
import fr.zebasto.spring.identity.contract.service.GroupService;
import fr.zebasto.spring.identity.contract.service.RoleService;
import fr.zebasto.spring.identity.core.service.AbstractUserService;
import fr.zebasto.spring.identity.defaults.model.DefaultUser;
import fr.zebasto.spring.identity.defaults.repository.DefaultUserRepository;
import org.springframework.security.crypto.password.PasswordEncoder;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.UUID;

/**
 * Simple Service implementation used to manage {@link DefaultUser} entity
 *
 * @author Bastien Cecchinato
 * @since 1.0.0
 */
@Named("userService")
public class DefaultUserService extends AbstractUserService<DefaultUser, UUID, DefaultUserRepository> {
    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("userRepository")
    public void setRepository(DefaultUserRepository userRepository) {
        super.setRepository(userRepository);
    }

    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("groupService")
    public void setGroupService(GroupService groupService) {
        super.setGroupService(groupService);
    }

    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("applicationService")
    public void setApplicationService(ApplicationService applicationService) {
        super.setApplicationService(applicationService);
    }

    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("roleService")
    public void setRoleService(RoleService roleService) {
        super.setRoleService(roleService);
    }

    /**
     * {@inheritDoc}
     */
    @Inject
    @Override
    @Named("passwordEncoder")
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        super.setPasswordEncoder(passwordEncoder);
    }
}
