/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.configuration.IdentityRoles;
import fr.zebasto.spring.identity.defaults.model.DefaultAction;
import fr.zebasto.spring.identity.defaults.repository.DefaultActionRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.annotation.Profile;
import org.springframework.util.ReflectionUtils;

@Named(value="actionInitializer")
@Profile(value={"identity-data", "identity-data-action"})
public class ActionInitializer {
    @Inject
    @Named(value="actionRepository")
    private DefaultActionRepository actionRepository;

    @PostInitialize(order=1)
    public void initializeData() {
        ReflectionUtils.doWithFields(IdentityRoles.Actions.class, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ActionInitializer.this.actionRepository.save(new DefaultAction(field.getName()));
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return !field.getName().contains("this") && ActionInitializer.this.actionRepository.findByName(field.getName()) == null;
            }
        });
    }
}

