/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.configuration.IdentityRoles;
import fr.zebasto.spring.identity.defaults.model.DefaultApplication;
import fr.zebasto.spring.identity.defaults.repository.DefaultApplicationRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.annotation.Profile;
import org.springframework.util.ReflectionUtils;

@Named(value="applicationInitializer")
@Profile(value={"identity-data", "identity-data-application"})
public class ApplicationInitializer {
    @Inject
    @Named(value="applicationRepository")
    private DefaultApplicationRepository applicationRepository;

    @PostInitialize(order=1)
    public void initializeData() {
        ReflectionUtils.doWithFields(IdentityRoles.Applications.class, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ApplicationInitializer.this.applicationRepository.save(new DefaultApplication(field.getName()));
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return !field.getName().contains("this") && ApplicationInitializer.this.applicationRepository.findByName(field.getName()) == null;
            }
        });
    }
}

