/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.model.DefaultGroup;
import fr.zebasto.spring.identity.defaults.repository.DefaultGroupRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultRoleRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultUserRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.annotation.Profile;

@Named(value="groupInitializer")
@Profile(value={"identity-data", "identity-data-group"})
public class GroupInitializer {
    @Inject
    @Named(value="groupRepository")
    private DefaultGroupRepository groupRepository;
    @Inject
    @Named(value="roleRepository")
    private DefaultRoleRepository roleRepository;
    @Inject
    @Named(value="userRepository")
    private DefaultUserRepository userRepository;

    @PostInitialize(order=4)
    public void initializeData() {
        DefaultGroup demoGroup = new DefaultGroup();
        demoGroup.setName("Demo Group");
        demoGroup.getUsers().addAll(this.userRepository.findAll());
        demoGroup.getRoles().add(this.roleRepository.findByName("Role Read ALL"));
        this.groupRepository.save(demoGroup);
        DefaultGroup adminGroup = new DefaultGroup();
        adminGroup.setName("Admin Group");
        adminGroup.getGroups().add(demoGroup);
        adminGroup.getUsers().addAll(this.userRepository.findByLogin("admin"));
        adminGroup.getRoles().add(this.roleRepository.findByName("Role Create ALL"));
        adminGroup.getRoles().add(this.roleRepository.findByName("Role Update ALL"));
        adminGroup.getRoles().add(this.roleRepository.findByName("Role Delete ALL"));
        this.groupRepository.save(adminGroup);
    }
}

