/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.configuration.IdentityRoles;
import fr.zebasto.spring.identity.defaults.model.DefaultAction;
import fr.zebasto.spring.identity.defaults.model.DefaultApplication;
import fr.zebasto.spring.identity.defaults.model.DefaultPermission;
import fr.zebasto.spring.identity.defaults.repository.DefaultActionRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultApplicationRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultPermissionRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.annotation.Profile;
import org.springframework.util.ReflectionUtils;

@Named(value="permissionInitializer")
@Profile(value={"identity-data", "identity-data-permission"})
public class PermissionInitializer {
    @Inject
    @Named(value="applicationRepository")
    private DefaultApplicationRepository applicationRepository;
    @Inject
    @Named(value="actionRepository")
    private DefaultActionRepository actionRepository;
    @Inject
    @Named(value="permissionRepository")
    private DefaultPermissionRepository permissionRepository;
    private ReflectionUtils.FieldFilter filter = new ReflectionUtils.FieldFilter(){

        public boolean matches(Field field) {
            return !field.getName().contains("this");
        }
    };

    @PostInitialize(order=2)
    public void initializeData() {
        ReflectionUtils.doWithFields(IdentityRoles.Applications.class, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field application) throws IllegalArgumentException, IllegalAccessException {
                final DefaultApplication defaultApplication = (DefaultApplication)PermissionInitializer.this.applicationRepository.findByName(application.getName());
                ReflectionUtils.doWithFields(IdentityRoles.Actions.class, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                    public void doWith(Field action) throws IllegalArgumentException, IllegalAccessException {
                        DefaultAction defaultAction = (DefaultAction)PermissionInitializer.this.actionRepository.findByName(action.getName());
                        PermissionInitializer.this.permissionRepository.save(new DefaultPermission(MessageFormat.format("Auto-Created-{0}-{1}", defaultApplication.getName(), defaultAction.getName()), "Permission Auto Created by PermissionInitializer.class", defaultApplication, defaultAction));
                    }
                }, (ReflectionUtils.FieldFilter)PermissionInitializer.this.filter);
            }
        }, (ReflectionUtils.FieldFilter)this.filter);
    }
}

