/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.model.DefaultRole;
import fr.zebasto.spring.identity.defaults.repository.DefaultPermissionRepository;
import fr.zebasto.spring.identity.defaults.repository.DefaultRoleRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.annotation.Profile;

@Named(value="roleInitializer")
@Profile(value={"identity-data", "identity-data-role"})
public class RoleInitializer {
    @Inject
    @Named(value="roleRepository")
    private DefaultRoleRepository roleRepository;
    @Inject
    @Named(value="permissionRepository")
    private DefaultPermissionRepository permissionRepository;

    @PostInitialize(order=3)
    public void initializeData() {
        DefaultRole readRole = new DefaultRole();
        readRole.setName("Role Read ALL");
        readRole.getPermissions().addAll(this.permissionRepository.findByCodeLike("PERMISSION_READ_%"));
        this.roleRepository.save(readRole);
        DefaultRole createRole = new DefaultRole();
        createRole.setName("Role Create ALL");
        createRole.getPermissions().addAll(this.permissionRepository.findByCodeLike("PERMISSION_CREATE_%"));
        this.roleRepository.save(createRole);
        DefaultRole updateRole = new DefaultRole();
        updateRole.setName("Role Update ALL");
        updateRole.getPermissions().addAll(this.permissionRepository.findByCodeLike("PERMISSION_UPDATE_%"));
        this.roleRepository.save(updateRole);
        DefaultRole deleteRole = new DefaultRole();
        deleteRole.setName("Role Delete ALL");
        deleteRole.getPermissions().addAll(this.permissionRepository.findByCodeLike("PERMISSION_DELETE_%"));
        this.roleRepository.save(deleteRole);
    }
}

