/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.data;

import fr.zebasto.spring.identity.defaults.model.DefaultUser;
import fr.zebasto.spring.identity.defaults.repository.DefaultUserRepository;
import fr.zebasto.spring.post.initialize.annotation.PostInitialize;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;

@Named(value="userInitializer")
@Profile(value={"identity-data", "identity-data-user"})
public class UserInitializer {
    @Inject
    @Named(value="userRepository")
    private DefaultUserRepository userRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @PostInitialize(order=1)
    public void initializeData() {
        DefaultUser demoUser = new DefaultUser();
        demoUser.setLogin("demo");
        demoUser.setPassword(this.passwordEncoder.encode((CharSequence)"demo"));
        demoUser.setEmail("demo@spring-identity.org");
        demoUser.setFirstName("Demo");
        demoUser.setLastName("Demo");
        this.userRepository.save(demoUser);
        DefaultUser adminUser = new DefaultUser();
        adminUser.setLogin("admin");
        adminUser.setPassword(this.passwordEncoder.encode((CharSequence)"admin"));
        adminUser.setEmail("admin@spring-identity.org");
        adminUser.setFirstName("Admin");
        adminUser.setLastName("Admin");
        this.userRepository.save(adminUser);
    }
}

