/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import fr.zebasto.spring.identity.contract.model.Group;
import fr.zebasto.spring.identity.contract.model.Permission;
import fr.zebasto.spring.identity.contract.model.Role;
import fr.zebasto.spring.identity.contract.model.User;
import fr.zebasto.spring.identity.defaults.model.DefaultPermission;
import fr.zebasto.spring.identity.defaults.model.DefaultRole;
import fr.zebasto.spring.identity.defaults.model.DefaultUser;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="IDENTITY_GROUPS")
public class DefaultGroup
implements Group<UUID> {
    private UUID id = UUID.randomUUID();
    private String name = null;
    private List<Permission> permissions = new ArrayList<Permission>();
    private List<Group> groups = new ArrayList<Group>();
    private List<User> users = new ArrayList<User>();
    private List<Role> roles = new ArrayList<Role>();

    @Id
    @Type(type="uuid-char")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @NotNull
    @NotEmpty
    @Column(unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonDeserialize(contentAs=DefaultPermission.class)
    @JoinTable(name="IDENTITY_MAPPING_GROUP_PERMISSION")
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultPermission.class)
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    @JsonDeserialize(contentAs=DefaultGroup.class)
    @JoinTable(name="IDENTITY_MAPPING_GROUP_GROUP")
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultGroup.class)
    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @JsonDeserialize(contentAs=DefaultUser.class)
    @JsonIgnoreProperties(value={"permissions", "groups", "roles"})
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultUser.class)
    @JoinTable(name="IDENTITY_MAPPING_GROUP_USER", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    @JsonDeserialize(contentAs=DefaultRole.class)
    @JoinTable(name="IDENTITY_MAPPING_GROUP_ROLE")
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultRole.class)
    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

