/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import fr.zebasto.spring.identity.contract.model.Action;
import fr.zebasto.spring.identity.contract.model.Application;
import fr.zebasto.spring.identity.contract.model.Permission;
import fr.zebasto.spring.identity.defaults.model.DefaultAction;
import fr.zebasto.spring.identity.defaults.model.DefaultApplication;
import java.text.MessageFormat;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="IDENTITY_PERMISSIONS")
public class DefaultPermission
implements Permission<UUID> {
    private UUID id = UUID.randomUUID();
    private String title;
    private String description;
    private Application application;
    private Action action;
    private String code;

    public DefaultPermission() {
    }

    public DefaultPermission(String title, String description, Application application, Action action) {
        this.title = title;
        this.description = description;
        this.application = application;
        this.action = action;
    }

    @Id
    @Type(type="uuid-char")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @Column(nullable=false, unique=true)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @JsonDeserialize(as=DefaultAction.class)
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=DefaultAction.class)
    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @Column
    @NotNull
    @NotEmpty
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column
    @NotNull
    @NotEmpty
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonDeserialize(as=DefaultApplication.class)
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=DefaultApplication.class)
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @PostLoad
    @PreUpdate
    @PrePersist
    public void updateCode() {
        this.code = MessageFormat.format("{0}_{1}_{2}", "PERMISSION", this.action.getName(), this.application.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPermission that = (DefaultPermission)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

