/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import fr.zebasto.spring.identity.contract.model.Permission;
import fr.zebasto.spring.identity.contract.model.Role;
import fr.zebasto.spring.identity.defaults.model.DefaultPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="IDENTITY_ROLES")
public class DefaultRole
implements Role<UUID> {
    private UUID id = UUID.randomUUID();
    private String name;
    private List<Permission> permissions = new ArrayList<Permission>();

    public DefaultRole() {
    }

    public DefaultRole(String roleName) {
        this.setName(roleName);
    }

    @Id
    @Type(type="uuid-char")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @Column(unique=true, nullable=false)
    @NotNull
    @NotEmpty
    public String getName() {
        return this.name;
    }

    public void setName(String roleName) {
        this.name = roleName;
    }

    @JsonDeserialize(contentAs=DefaultPermission.class)
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultPermission.class)
    @JoinTable(name="IDENTITY_MAPPING_ROLE_PERMISSION")
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRole other = (DefaultRole)obj;
        return !(this.id == null ? other.getId() != null : !this.id.equals(other.getId()));
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + (this.id == null ? 0 : this.id.hashCode());
        return hash;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

