/*
 * Decompiled with CFR 0.152.
 */
package fr.zebasto.spring.identity.defaults.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import fr.zebasto.spring.identity.contract.model.Group;
import fr.zebasto.spring.identity.contract.model.Permission;
import fr.zebasto.spring.identity.contract.model.Role;
import fr.zebasto.spring.identity.contract.model.User;
import fr.zebasto.spring.identity.defaults.model.DefaultGroup;
import fr.zebasto.spring.identity.defaults.model.DefaultPermission;
import fr.zebasto.spring.identity.defaults.model.DefaultRole;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="IDENTITY_USERS")
public class DefaultUser
implements User<UUID> {
    private UUID id = UUID.randomUUID();
    private String firstName;
    private String lastName;
    private String login;
    private String password;
    private String email;
    private List<Permission> permissions = new ArrayList<Permission>();
    private List<Group> groups = new ArrayList<Group>();
    private List<Role> roles = new ArrayList<Role>();

    @Id
    @Type(type="uuid-char")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @NotNull
    @NotEmpty
    @Column(unique=true)
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @NotNull
    @NotEmpty
    @Column(length=60)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @JsonDeserialize(contentAs=DefaultPermission.class)
    @JoinTable(name="IDENTITY_MAPPING_USER_PERMISSION")
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultPermission.class)
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    @JsonDeserialize(contentAs=DefaultGroup.class)
    @JsonIgnoreProperties(value={"permissions", "groups", "users", "roles"})
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultGroup.class)
    @JoinTable(name="IDENTITY_MAPPING_GROUP_USER", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @JsonDeserialize(contentAs=DefaultRole.class)
    @JoinTable(name="IDENTITY_MAPPING_USER_ROLE")
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=DefaultRole.class)
    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    @Column
    @NotEmpty
    @NotNull
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column
    @NotEmpty
    @NotNull
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Email
    @NotNull
    @Column(unique=true)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

