/*
 * Decompiled with CFR 0.152.
 */
package hk.hku.cecid.phoenix.pki;

import hk.hku.cecid.phoenix.common.util.Logger;
import hk.hku.cecid.phoenix.common.util.Version;
import hk.hku.cecid.phoenix.pki.CertPathVerifier;
import hk.hku.cecid.phoenix.pki.CompositeKeyStore;
import hk.hku.cecid.phoenix.pki.DocumentDetail;
import hk.hku.cecid.phoenix.pki.DocumentResolver;
import hk.hku.cecid.phoenix.pki.SignException;
import hk.hku.cecid.phoenix.pki.VerifyException;
import hk.hku.cecid.phoenix.pki.XMLDSigner;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApacheXMLDSigner
implements XMLDSigner {
    protected static Logger logger = Logger.getLogger((String)(class$hk$hku$cecid$phoenix$pki$ApacheXMLDSigner == null ? (class$hk$hku$cecid$phoenix$pki$ApacheXMLDSigner = ApacheXMLDSigner.class$("hk.hku.cecid.phoenix.pki.ApacheXMLDSigner")) : class$hk$hku$cecid$phoenix$pki$ApacheXMLDSigner).getName());
    protected static final String DSIG_URI = "http://www.w3.org/2000/09/xmldsig#";
    protected Document envelope = null;
    protected ArrayList documents = new ArrayList();
    protected CompositeKeyStore trusted = null;
    protected XMLSignature signature = null;
    static /* synthetic */ Class class$hk$hku$cecid$phoenix$pki$ApacheXMLDSigner;

    public void setEnvelope(Document doc, String algo) throws SignException {
        this.envelope = doc;
        try {
            this.signature = new XMLSignature(this.envelope, DSIG_URI, DSIG_URI + algo);
        }
        catch (XMLSecurityException e) {
            throw new SignException("Cannot create XMLSignature object:\n" + e.getMessage());
        }
        logger.debug("setEnvelope, using algorithm: " + algo);
    }

    public void setEnvelope(Document doc) throws SignException {
        this.setEnvelope(doc, "dsa-sha1");
    }

    public void addDocument(String uri, InputStream is, String contentType) {
        DocumentDetail dd = new DocumentDetail();
        dd.uri = uri;
        dd.stream = is;
        dd.contentType = contentType;
        this.documents.add(dd);
        logger.debug("addDocument URI: " + uri + ", contentType: " + contentType);
    }

    public void sign(CompositeKeyStore ks, String alias, char[] password) throws SignException {
        PrivateKey pk;
        Certificate[] certificates;
        logger.debug("start signing...");
        if (this.envelope == null) {
            throw new SignException("Envelope element not set!");
        }
        DocumentDetail[] doc_array = new DocumentDetail[this.documents.size()];
        int i = 0;
        while (i < doc_array.length) {
            doc_array[i] = (DocumentDetail)this.documents.get(i);
            ++i;
        }
        DocumentResolver resolver = new DocumentResolver(doc_array);
        this.signature.addResourceResolver((ResourceResolverSpi)resolver);
        logger.debug("created DocumentResolver");
        Transforms transforms = new Transforms(this.envelope);
        try {
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            Element xpath = this.envelope.createElementNS(DSIG_URI, "XPath");
            xpath.setAttribute("xmlns:soap-env", "http://schemas.xmlsoap.org/soap/envelope/");
            xpath.appendChild(this.envelope.createTextNode("not(ancestor-or-self::node()[@soap-env:actor=\"urn:oasis:names:tc:ebxml-msg:actor:nextMSH\"] | ancestor-or-self::node()[@soap-env:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])"));
            xpath.setPrefix("ds");
            transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xpath);
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        }
        catch (TransformationException e) {
            throw new SignException("Cannot add tranform:\n" + e.getMessage());
        }
        logger.debug("created Transform");
        try {
            this.signature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        }
        catch (XMLSignatureException e) {
            throw new SignException("Cannot add envelope document:\n" + e.getMessage());
        }
        logger.debug("added main document (envelope)");
        int i2 = 0;
        while (i2 < this.documents.size()) {
            DocumentDetail dd = (DocumentDetail)this.documents.get(i2);
            try {
                this.signature.addDocument(dd.uri);
            }
            catch (XMLSignatureException e) {
                throw new SignException("Cannot add document " + dd.uri + ":\n" + e.getMessage());
            }
            ++i2;
        }
        logger.debug("added " + this.documents.size() + " attachment documents");
        try {
            certificates = ks.getCertificateChain(alias);
            if (certificates == null) {
                throw new SignException("Cannot get certificates path - " + alias);
            }
        }
        catch (KeyStoreException e) {
            throw new SignException("Cannot get certificates path - " + alias + ":\n" + e.getMessage());
        }
        logger.debug("got the certificate chain from keystore");
        int i3 = 0;
        while (i3 < certificates.length) {
            try {
                this.signature.addKeyInfo((X509Certificate)certificates[i3]);
            }
            catch (XMLSecurityException e) {
                throw new SignException("Cannot add key info:\n" + e.getMessage());
            }
            ++i3;
        }
        logger.debug("added the certificate chain to signature");
        try {
            pk = (PrivateKey)ks.getKey(alias, password);
        }
        catch (Exception e) {
            throw new SignException("Cannot get private key - " + alias + ":\n" + e.getMessage());
        }
        logger.debug("got private key from keystore");
        try {
            this.signature.sign(pk);
        }
        catch (XMLSignatureException e) {
            e.printStackTrace();
            throw new SignException("Cannot sign:\n" + e.getMessage());
        }
        logger.debug("signed");
    }

    public void setTrustAnchor(CompositeKeyStore ks) {
        this.trusted = ks;
    }

    public boolean verify() throws VerifyException {
        logger.debug("start verifying...");
        if (this.envelope == null) {
            throw new VerifyException("Envelope element not set!");
        }
        NodeList nodeList = this.envelope.getElementsByTagNameNS(DSIG_URI, "Signature");
        if (nodeList.getLength() == 0) {
            throw new VerifyException("No <ds:Signature> found!");
        }
        Element signatureElement = (Element)nodeList.item(0);
        String baseUri = DSIG_URI;
        logger.debug("got the signature element");
        try {
            this.signature = new XMLSignature(signatureElement, baseUri);
        }
        catch (XMLSecurityException e) {
            throw new VerifyException("Cannot create XMLSignature object:\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new VerifyException("Cannot create XMLSignature object:\n" + e.getMessage());
        }
        logger.debug("created signature object");
        DocumentDetail[] doc_array = new DocumentDetail[this.documents.size()];
        int i = 0;
        while (i < doc_array.length) {
            doc_array[i] = (DocumentDetail)this.documents.get(i);
            ++i;
        }
        DocumentResolver resolver = new DocumentResolver(doc_array);
        this.signature.addResourceResolver((ResourceResolverSpi)resolver);
        logger.debug("created document resolver");
        PublicKey publicKey = null;
        KeyInfo keyInfo = this.signature.getKeyInfo();
        Certificate[] certs = null;
        if (keyInfo != null) {
            try {
                X509Certificate certificate;
                int certPathLen = keyInfo.lengthX509Data();
                if (certPathLen > 0) {
                    certs = new Certificate[certPathLen];
                    int i2 = 0;
                    while (i2 < certPathLen) {
                        try {
                            certs[i2] = keyInfo.itemX509Data(i2).itemCertificate(0).getX509Certificate();
                        }
                        catch (XMLSecurityException e) {
                            throw new VerifyException("Cannot get keys from <ds:KeyInfo>:\n" + e.getMessage());
                        }
                        ++i2;
                    }
                }
                if ((certificate = keyInfo.getX509Certificate()) != null) {
                    publicKey = certificate.getPublicKey();
                }
            }
            catch (KeyResolverException e) {
                throw new VerifyException("Cannot extract key info:\n" + e.getMessage());
            }
        }
        if (publicKey == null) {
            throw new VerifyException("No PublicKey can be found!");
        }
        logger.debug("got public key and certificate chain from signature");
        boolean ret = false;
        try {
            ret = this.signature.checkSignatureValue(publicKey);
        }
        catch (XMLSignatureException e) {
            throw new VerifyException("Cannot verify:\n" + e.getMessage());
        }
        logger.debug("checked signature value, result: " + ret);
        double javaVersion = Version.getJDKVersion();
        if (ret && this.trusted != null && certs != null && certs.length > 1 && javaVersion >= 1.4) {
            logger.debug("start verifying cert path...");
            CertPathVerifier.verify(certs, this.trusted);
            logger.debug("verified, result: " + ret);
        } else {
            logger.debug("verification of cert path skipped...");
        }
        return ret;
    }

    public Element getElement() {
        if (this.signature != null) {
            return this.signature.getElement();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

