/*
 * Decompiled with CFR 0.152.
 */
package hk.hku.cecid.phoenix.pki;

import hk.hku.cecid.phoenix.pki.CRLSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;

public class CRLFileSource
extends CRLSource {
    protected File crlFile;

    public CRLFileSource() {
        this.crlFile = null;
    }

    public CRLFileSource(String crlFile) {
        this(new File(crlFile));
    }

    public CRLFileSource(File crlFile) {
        this.crlFile = crlFile;
    }

    public void init() throws CRLException {
        if (this.crlFile == null || !this.crlFile.exists() || !this.crlFile.isFile()) {
            throw new CRLException("Error loading file: " + this.crlFile + ".\n");
        }
        try {
            FileInputStream inStream = new FileInputStream(this.crlFile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.crl = (X509CRL)cf.generateCRL(inStream);
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            throw new CRLException("IO exception when loading crl file.\n" + e.getMessage());
        }
        catch (CertificateException e) {
            throw new CRLException("Certificate exception when loading crl file.\n" + e.getMessage());
        }
        this.ready = true;
    }
}

