/*
 * Decompiled with CFR 0.152.
 */
package hk.hku.cecid.phoenix.pki;

import hk.hku.cecid.phoenix.pki.CertSource;
import hk.hku.cecid.phoenix.pki.InitializationException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.util.Date;

public abstract class CRLSource {
    protected X509CRL crl = null;
    protected boolean ready = false;

    public abstract void init() throws CRLException;

    public boolean isReady() {
        return this.ready && this.crl != null;
    }

    public boolean verifySignature(PublicKey pubKey) throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        boolean ret = false;
        try {
            this.crl.verify(pubKey);
            ret = true;
        }
        catch (CRLException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (SignatureException e) {}
        return ret;
    }

    public boolean verifySignature(Certificate cert) throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.verifySignature(cert.getPublicKey());
    }

    public boolean verifySignature(CertSource cert) throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.verifySignature(cert.getPublicKey());
    }

    public boolean isRevoked(Certificate cert) throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.crl.isRevoked(cert);
    }

    public boolean isRevoked(CertSource cert) throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.isRevoked(cert.getInternalCert());
    }

    public Date getThisUpdate() throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.crl.getThisUpdate();
    }

    public Date getNextUpdate() throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.crl.getNextUpdate();
    }

    public String getIssuer() throws InitializationException {
        if (!this.isReady()) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.crl.getIssuerDN().getName();
    }
}

