/*
 * Decompiled with CFR 0.152.
 */
package hk.hku.cecid.phoenix.pki;

import hk.hku.cecid.phoenix.common.util.Logger;
import hk.hku.cecid.phoenix.pki.CompositeKeyStore;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class CertPathVerifier {
    protected static Logger logger = Logger.getLogger((String)(class$hk$hku$cecid$phoenix$pki$CertPathVerifier == null ? (class$hk$hku$cecid$phoenix$pki$CertPathVerifier = CertPathVerifier.class$("hk.hku.cecid.phoenix.pki.CertPathVerifier")) : class$hk$hku$cecid$phoenix$pki$CertPathVerifier).getName());
    static /* synthetic */ Class class$hk$hku$cecid$phoenix$pki$CertPathVerifier;

    public static boolean verify(Certificate[] certs, CompositeKeyStore trusted) {
        try {
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            X509CertSelector targetConstraints = new X509CertSelector();
            int i = 0;
            while (i < certs.length) {
                targetConstraints.setSubject(((X509Certificate)certs[i]).getSubjectX500Principal().getEncoded());
                ++i;
            }
            KeyStore trustAnchorsKS = trusted.getKeyStore();
            if (trustAnchorsKS == null) {
                logger.debug("trustAnchorsKS is null");
                return false;
            }
            PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchorsKS, (CertSelector)targetConstraints);
            ArrayList<Certificate> certsList = new ArrayList<Certificate>();
            int i2 = 0;
            while (i2 < certs.length) {
                certsList.add(certs[i2]);
                ++i2;
            }
            CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters();
            CertStore store = CertStore.getInstance("Collection", ccsp);
            params.addCertStore(store);
            CertPath certPath = certPathBuilder.build(params).getCertPath();
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug("NoSuchAlgorithmException thrown");
            return false;
        }
        catch (IOException e) {
            logger.debug("IOException thrown");
            return false;
        }
        catch (KeyStoreException e) {
            logger.debug("KeyStoreException thrown");
            return false;
        }
        catch (CertPathBuilderException e) {
            logger.debug("CertPathBuilderException thrown");
            return false;
        }
        catch (InvalidAlgorithmParameterException e) {
            logger.debug("InvalidAlgorithmParameterException thrown");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

