/*
 * Decompiled with CFR 0.152.
 */
package hk.hku.cecid.phoenix.pki;

import hk.hku.cecid.phoenix.pki.InitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CertSource {
    protected X509Certificate x509Cert;

    public CertSource() {
        this.x509Cert = null;
    }

    public CertSource(File certFile) throws CertificateException {
        this();
        this.load(certFile);
    }

    public CertSource(String certFile) throws CertificateException {
        this();
        this.load(certFile);
    }

    public CertSource(X509Certificate cert) {
        this.x509Cert = cert;
    }

    public void load(File certFile) throws CertificateException {
        try {
            FileInputStream inStream = new FileInputStream(certFile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            throw new CertificateException("IO exception when loading certificate file.\n" + e.getMessage());
        }
    }

    public void load(String certFile) throws CertificateException {
        this.load(new File(certFile));
    }

    public boolean isValid() throws InitializationException {
        if (this.x509Cert == null) {
            throw new InitializationException("Not yet initialized.");
        }
        boolean ret = false;
        try {
            this.x509Cert.checkValidity();
            ret = true;
        }
        catch (CertificateExpiredException e) {
        }
        catch (CertificateNotYetValidException e) {}
        return ret;
    }

    public boolean isValid(Date d) throws InitializationException {
        if (this.x509Cert == null) {
            throw new InitializationException("Not yet initialized.");
        }
        boolean ret = false;
        try {
            this.x509Cert.checkValidity(d);
            ret = true;
        }
        catch (CertificateExpiredException e) {
        }
        catch (CertificateNotYetValidException e) {}
        return ret;
    }

    public boolean verify(PublicKey pubKey) throws InitializationException {
        if (this.x509Cert == null) {
            throw new InitializationException("Not yet initialized.");
        }
        boolean ret = false;
        try {
            this.x509Cert.verify(pubKey);
            ret = true;
        }
        catch (CertificateException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (SignatureException e) {}
        return ret;
    }

    public boolean verify(Certificate cert) throws InitializationException {
        if (this.x509Cert == null) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.verify(this.x509Cert.getPublicKey());
    }

    public boolean verify(CertSource cert) throws InitializationException {
        if (this.x509Cert == null) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.verify(this.x509Cert.getPublicKey());
    }

    public PublicKey getPublicKey() {
        try {
            return this.x509Cert.getPublicKey();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public X509Certificate getInternalCert() {
        return this.x509Cert;
    }

    public String getIssuer() throws InitializationException {
        if (this.x509Cert == null) {
            throw new InitializationException("Not yet initialized.");
        }
        return this.x509Cert.getIssuerDN().getName();
    }
}

