/*
 * Decompiled with CFR 0.152.
 */
package hk.hku.cecid.phoenix.pki;

import hk.hku.cecid.phoenix.common.util.Logger;
import hk.hku.cecid.phoenix.common.util.Version;
import hk.hku.cecid.phoenix.pki.InitializationException;
import hk.hku.cecid.phoenix.pki.KeyStoreFileProp;
import hk.hku.cecid.phoenix.pki.StoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CompositeKeyStore {
    protected static Logger logger = Logger.getLogger((String)(class$hk$hku$cecid$phoenix$pki$CompositeKeyStore == null ? (class$hk$hku$cecid$phoenix$pki$CompositeKeyStore = CompositeKeyStore.class$("hk.hku.cecid.phoenix.pki.CompositeKeyStore")) : class$hk$hku$cecid$phoenix$pki$CompositeKeyStore).getName());
    protected Hashtable storage = new Hashtable();
    protected Hashtable cache = null;
    protected Vector keystores = new Vector();
    static /* synthetic */ Class class$hk$hku$cecid$phoenix$pki$CompositeKeyStore;

    public void addKeyStoreFile(String keyFile, String type, char[] password) {
        if (keyFile == null) {
            logger.debug("Keystore file cannot be <null>!");
        } else {
            File f = new File(keyFile);
            if (f == null || !f.exists()) {
                logger.debug("Keystore file " + keyFile + " not found!");
            } else {
                this.addKeyStoreFile(f, type, password);
            }
        }
    }

    protected void addKeyStoreFile(File keyFile, String type, char[] password) {
        KeyStoreFileProp ksp = new KeyStoreFileProp(type, password);
        try {
            this.storage.put(keyFile.getCanonicalPath(), ksp);
        }
        catch (IOException e) {}
    }

    public KeyStore getKeyStore() {
        if (this.cache == null) {
            this.loadCache();
        }
        if (this.keystores.size() > 0) {
            return (KeyStore)this.keystores.get(0);
        }
        return null;
    }

    public void removeKeyStoreFile(String keyFile) {
        this.removeKeyStoreFile(new File(keyFile));
    }

    protected void removeKeyStoreFile(File keyFile) {
        try {
            this.storage.remove(keyFile.getCanonicalPath());
        }
        catch (IOException e) {}
    }

    protected KeyStore loadKeyStore(String fileName, KeyStoreFileProp ksp) {
        KeyStore ks = null;
        if (ksp.getType() == null) {
            KeyStoreFileProp ksp_new = new KeyStoreFileProp("JKS", ksp.getPassword());
            ks = this.loadKeyStore(fileName, ksp_new);
            if (ks == null) {
                ksp_new = new KeyStoreFileProp("PKCS12", ksp.getPassword());
                ks = this.loadKeyStore(fileName, ksp_new);
            }
            return ks;
        }
        if (ksp.getType().toUpperCase().equals("JKS")) {
            try {
                ks = KeyStore.getInstance("JKS");
            }
            catch (KeyStoreException e) {}
        } else if (ksp.getType().toUpperCase().equals("PKCS12")) {
            if (CompositeKeyStore.isUsingJSSE()) {
                try {
                    Class<?> clsProv = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
                    Constructor<?> c = clsProv.getConstructor(null);
                    Provider provider = (Provider)c.newInstance(null);
                    if (Security.getProvider(provider.getName()) == null) {
                        Security.addProvider(provider);
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoSuchMethodException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                try {
                    ks = KeyStore.getInstance("PKCS12", "SunJSSE");
                }
                catch (NoSuchProviderException e) {
                }
                catch (KeyStoreException e) {}
            } else {
                try {
                    ks = KeyStore.getInstance("PKCS12");
                }
                catch (KeyStoreException e) {
                    // empty catch block
                }
            }
        }
        if (ks != null) {
            try {
                ks.load(new FileInputStream(fileName), ksp.getPassword());
                return ks;
            }
            catch (IOException e) {
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (CertificateException e) {
            }
        }
        return null;
    }

    protected void loadCache() {
        this.cache = new Hashtable();
        Enumeration fileNames = this.storage.keys();
        while (fileNames.hasMoreElements()) {
            String fileName = (String)fileNames.nextElement();
            KeyStoreFileProp ksp = (KeyStoreFileProp)this.storage.get(fileName);
            KeyStore ks = this.loadKeyStore(fileName, ksp);
            this.keystores.add(ks);
            if (ks == null) continue;
            try {
                Enumeration<String> ks_alias = ks.aliases();
                while (ks_alias.hasMoreElements()) {
                    this.cache.put(ks_alias.nextElement(), ks);
                }
            }
            catch (KeyStoreException e) {
                // empty catch block
            }
        }
    }

    public Enumeration aliases() {
        if (this.cache == null) {
            this.loadCache();
        }
        return this.cache.keys();
    }

    public boolean containsAlias(String alias) {
        if (this.cache == null) {
            this.loadCache();
        }
        return this.cache.get(alias) != null;
    }

    public Certificate getCertificate(String alias) throws KeyStoreException {
        KeyStore ks;
        if (this.cache == null) {
            this.loadCache();
        }
        if ((ks = (KeyStore)this.cache.get(alias)) != null) {
            return ks.getCertificate(alias);
        }
        return null;
    }

    public String getCertificateAlias(Certificate cert) {
        if (this.cache == null) {
            this.loadCache();
        }
        Enumeration keyStores = this.cache.elements();
        while (keyStores.hasMoreElements()) {
            KeyStore ks = (KeyStore)keyStores.nextElement();
            try {
                String alias = ks.getCertificateAlias(cert);
                if (alias == null) continue;
                return alias;
            }
            catch (KeyStoreException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        KeyStore ks;
        if (this.cache == null) {
            this.loadCache();
        }
        if ((ks = (KeyStore)this.cache.get(alias)) != null) {
            return ks.getCertificateChain(alias);
        }
        return null;
    }

    public Date getCreationDate(String alias) throws KeyStoreException {
        KeyStore ks;
        if (this.cache == null) {
            this.loadCache();
        }
        if ((ks = (KeyStore)this.cache.get(alias)) != null) {
            return ks.getCreationDate(alias);
        }
        return null;
    }

    public Key getKey(String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore ks;
        if (this.cache == null) {
            this.loadCache();
        }
        if ((ks = (KeyStore)this.cache.get(alias)) != null) {
            return ks.getKey(alias, password);
        }
        return null;
    }

    public boolean isCertificateEntry(String alias) throws KeyStoreException {
        KeyStore ks;
        if (this.cache == null) {
            this.loadCache();
        }
        if ((ks = (KeyStore)this.cache.get(alias)) != null) {
            return ks.isCertificateEntry(alias);
        }
        return false;
    }

    public boolean isKeyEntry(String alias) throws KeyStoreException {
        KeyStore ks;
        if (this.cache == null) {
            this.loadCache();
        }
        if ((ks = (KeyStore)this.cache.get(alias)) != null) {
            return ks.isKeyEntry(alias);
        }
        return false;
    }

    public int size() {
        if (this.cache == null) {
            this.loadCache();
        }
        return this.cache.size();
    }

    public void load(String storeFileName) throws InitializationException {
        this.load(new File(storeFileName));
    }

    public void load(File storeFile) throws InitializationException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(storeFile));
            this.storage = (Hashtable)ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException e) {
            this.storage = null;
            throw new InitializationException("FileNotFound Exception\n" + e.getMessage());
        }
        catch (IOException e) {
            this.storage = null;
            throw new InitializationException("IO Exception\n" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this.storage = null;
            throw new InitializationException("ClassNotFound Exception\n" + e.getMessage());
        }
    }

    public void store(String storeFileName) throws StoreException {
        this.store(new File(storeFileName));
    }

    public void store(File storeFile) throws StoreException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(storeFile));
            oos.writeObject(this.storage);
            oos.close();
        }
        catch (FileNotFoundException e) {
            throw new StoreException("FileNotFound Exception\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new StoreException("IO Exception\n" + e.getMessage());
        }
    }

    protected static boolean isUsingJSSE() {
        double javaVersion = Version.getJDKVersion();
        return javaVersion < 1.4;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

