/*
 * Decompiled with CFR 0.152.
 */
package hk.hku.cecid.phoenix.pki;

import hk.hku.cecid.phoenix.pki.DocumentDetail;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class DocumentResolver
extends ResourceResolverSpi {
    protected DocumentDetail[] docs;

    public DocumentResolver(DocumentDetail[] docs) {
        this.docs = docs;
    }

    public XMLSignatureInput engineResolve(Attr uri, String baseUri) throws ResourceResolverException {
        XMLSignatureInput input;
        String href = uri.getNodeValue();
        if (!href.startsWith("cid:")) {
            Object[] exArgs = new Object[]{"Reference URI does not start with 'cid:'"};
            throw new ResourceResolverException(href, exArgs, uri, baseUri);
        }
        int found = -1;
        int i = 0;
        while (i < this.docs.length) {
            if (this.docs[i].uri != null && this.docs[i].uri.equals(href)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found < 0) {
            Object[] exArgs = new Object[]{"Reference URI = " + href + " does not exist!"};
            throw new ResourceResolverException(href, exArgs, uri, baseUri);
        }
        try {
            InputStream in = this.docs[found].stream;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int c = in.read(buffer);
            while (c != -1) {
                out.write(buffer, 0, c);
                c = in.read(buffer);
            }
            input = new XMLSignatureInput(out.toByteArray());
        }
        catch (Exception e) {
            throw new ResourceResolverException(href, e, uri, baseUri);
        }
        input.setSourceURI(href);
        input.setMIMEType(this.docs[found].contentType);
        return input;
    }

    public boolean engineCanResolve(Attr uri, String baseUri) {
        String href = uri.getNodeValue();
        if (href.startsWith("cid:")) {
            int i = 0;
            while (i < this.docs.length) {
                if (this.docs[i].uri != null && this.docs[i].uri.equals(href)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

