/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.bsf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.fulcrum.bsf.BSFService;

public class DefaultBSFService
extends AbstractLogEnabled
implements BSFService,
Configurable,
Initializable,
ThreadSafe,
Contextualizable {
    private String applicationRoot;
    protected static final String SCRIPTS_DIRECTORY = "scriptsDirectory";
    protected static final String DEFAULT_EXTENSION = "defaultExtension";
    protected BSFManager manager;
    protected String scriptsDirectory;
    protected String defaultExtension;

    public void execute(String script) {
        if (script.lastIndexOf(46) == -1) {
            script = script + '.' + this.defaultExtension;
        }
        script = this.getRealPath(this.scriptsDirectory + "/" + script);
        this.getLogger().debug("[BSFService] Script to execute: " + script);
        try {
            this.manager.exec(BSFManager.getLangFromFilename((String)script), script, 0, 0, (Object)this.fileContentsToString(script));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (BSFException bsfe) {
            int reason = bsfe.getReason();
            System.out.println("Reason:" + reason);
            bsfe.printStackTrace();
        }
    }

    protected String fileContentsToString(String file) throws IOException {
        StringWriter sw = new StringWriter();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf, 0, 1024)) != -1) {
            sw.write(buf, 0, len);
        }
        return sw.toString();
    }

    public String getRealPath(String path) {
        String absolutePath = null;
        absolutePath = this.applicationRoot == null ? new File(path).getAbsolutePath() : new File(this.applicationRoot, path).getAbsolutePath();
        return absolutePath;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.scriptsDirectory = conf.getAttribute(SCRIPTS_DIRECTORY, null);
        if (this.scriptsDirectory == null) {
            throw new ConfigurationException("You must provide a scripts directory in order to executes scripts!");
        }
        this.defaultExtension = conf.getAttribute(DEFAULT_EXTENSION, "bsf");
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }

    public void initialize() {
        this.manager = new BSFManager();
    }
}

