/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.cli;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.yaafi.cli.Shutdown;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainerImpl;
import org.apache.fulcrum.yaafi.framework.factory.ServiceManagerFactory;

public class Main {
    private ServiceContainer manager;
    private String componentRoleValue = "/componentRoles.xml";
    private String componentConfigValue = "/componentConfiguration.xml";
    private String componentParametersValue = "/parameters.properties";
    private Thread shutdownThread;
    private boolean isServerMode = false;
    private Logger logger = new ConsoleLogger(0);

    private Main() {
    }

    public static void main(String[] args) throws Exception {
        Main impl = new Main();
        impl.initialize();
        boolean terminateNow = !impl.isServerMode;
        while (!terminateNow) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                terminateNow = true;
            }
        }
        impl.dispose();
    }

    protected void initialize() throws Exception {
        this.manager = ServiceManagerFactory.create((Logger)new ConsoleLogger(), this.componentRoleValue, this.componentConfigValue, this.componentParametersValue);
        Shutdown shutdown = new Shutdown(this.getManager(), this.getLogger());
        this.shutdownThread = new Thread(shutdown);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    protected synchronized void dispose() throws Exception {
        if (this.getManager() != null) {
            this.getManager().dispose();
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public ServiceContainer getManager() {
        return this.manager;
    }

    public void setManager(ServiceContainerImpl manager) {
        this.manager = manager;
    }

    public String getComponentConfigValue() {
        return this.componentConfigValue;
    }

    public void setComponentConfigValue(String componentConfigValue) {
        this.componentConfigValue = componentConfigValue;
    }

    public String getComponentRoleValue() {
        return this.componentRoleValue;
    }

    public void setComponentRoleValue(String componentRoleValue) {
        this.componentRoleValue = componentRoleValue;
    }
}

