/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.container;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Executable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.activity.Suspendable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.yaafi.framework.container.ServiceComponent;

public class ServiceComponentImpl
implements ServiceComponent {
    private String name;
    private String clazzName;
    private Class clazz;
    private Object instance;
    private String shorthand;
    private Logger logger;
    private boolean isEarlyInit;

    public ServiceComponentImpl(Configuration configuration, Logger logger) throws ConfigurationException {
        this.notNull(configuration, "configuration");
        this.notNull(logger, "logger");
        if (configuration.getName().equals("role")) {
            this.clazzName = configuration.getAttribute("default-class");
            this.name = configuration.getAttribute("name", this.clazzName);
            this.shorthand = configuration.getAttribute("shorthand", this.name);
            this.logger = logger;
            this.isEarlyInit = configuration.getAttributeAsBoolean("early-init", true);
        } else {
            this.clazzName = configuration.getAttribute("class");
            this.name = configuration.getAttribute("name", this.clazzName);
            this.shorthand = configuration.getAttribute("shorthand", this.name);
            this.logger = logger;
            this.isEarlyInit = configuration.getAttributeAsBoolean("early-init", true);
        }
    }

    public Class loadClass() throws ClassNotFoundException {
        this.getLogger().debug("Loading the implementation class for " + this.getShorthand());
        this.clazz = this.getClass().getClassLoader().loadClass(this.clazzName);
        return this.clazz;
    }

    public Object create() throws InstantiationException, IllegalAccessException {
        this.getLogger().debug("Instantiating the implementation class for " + this.getShorthand());
        this.instance = this.clazz.newInstance();
        return this.instance;
    }

    public void enableLogging(Logger logger) {
        if (this.instance instanceof LogEnabled) {
            try {
                this.getLogger().debug("LogEnabled.enableLogging() for " + this.getShorthand());
                Logger avalonLogger = logger.getChildLogger(this.getClazzName());
                ((LogEnabled)this.getInstance()).enableLogging(avalonLogger);
            }
            catch (Throwable t) {
                String msg = "LogEnable the following service failed : " + this.getName();
                this.getLogger().error(msg, t);
                throw new RuntimeException(msg, t);
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.notNull(context, "context");
        if (this.instance instanceof Contextualizable) {
            try {
                this.getLogger().debug("Contextualizable.contextualize() for " + this.getShorthand());
                ((Contextualizable)this.getInstance()).contextualize(context);
            }
            catch (ContextException e) {
                String msg = "Contextualizing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                String msg = "Contextualizing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, t);
                throw new ContextException(msg, t);
            }
        }
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.notNull(serviceManager, "serviceManager");
        if (this.instance instanceof Serviceable) {
            try {
                this.getLogger().debug("Serviceable.service() for " + this.getShorthand());
                ((Serviceable)this.getInstance()).service(serviceManager);
            }
            catch (ServiceException e) {
                String msg = "Servicing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                String msg = "Servicing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, t);
                throw new RuntimeException(msg, t);
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.notNull(configuration, "configuration");
        if (this.instance instanceof Configurable) {
            try {
                this.getLogger().debug("Configurable.configure() for " + this.getShorthand());
                Configuration componentConfiguraton = configuration.getChild(this.getShorthand());
                ((Configurable)this.getInstance()).configure(componentConfiguraton);
            }
            catch (ConfigurationException e) {
                String msg = "Configuring the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                String msg = "Configuring the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, t);
                throw new ConfigurationException(msg, t);
            }
        }
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.notNull(parameters, "parameters");
        if (this.instance instanceof Parameterizable) {
            try {
                this.getLogger().debug("Parameterizable.parametrize() for " + this.getShorthand());
                ((Parameterizable)this.getInstance()).parameterize(parameters);
            }
            catch (ParameterException e) {
                String msg = "Parameterizing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                String msg = "Parameterizing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, t);
                throw new ParameterException(msg, t);
            }
        }
    }

    public void initialize() throws Exception {
        if (this.instance instanceof Initializable) {
            try {
                this.getLogger().debug("Initializable.initialize() for " + this.getShorthand());
                ((Initializable)this.getInstance()).initialize();
            }
            catch (Exception e) {
                String msg = "Initializing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                String msg = "Initializing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, t);
                throw new ConfigurationException(msg, t);
            }
        }
    }

    public void execute() throws Exception {
        if (this.instance instanceof Executable) {
            try {
                this.getLogger().debug("Executable.execute() for " + this.getShorthand());
                ((Executable)this.getInstance()).execute();
            }
            catch (Exception e) {
                String msg = "Executing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                String msg = "Executing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, t);
                throw new ConfigurationException(msg, t);
            }
        }
    }

    public void start() throws Exception {
        if (this.instance instanceof Startable) {
            try {
                this.getLogger().debug("Startable.start() for " + this.getShorthand());
                ((Startable)this.getInstance()).start();
            }
            catch (Exception e) {
                String msg = "Starting the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                String msg = "Starting the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, t);
                throw new RuntimeException(msg, t);
            }
        }
    }

    public void stop() throws Exception {
        if (this.instance instanceof Startable) {
            try {
                this.getLogger().debug("Startable.stop() for " + this.getShorthand());
                ((Startable)this.getInstance()).stop();
            }
            catch (Exception e) {
                String msg = "Stopping the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
        }
    }

    public void resume() {
        if (this.instance instanceof Suspendable) {
            try {
                this.getLogger().debug("Suspendable.resume() for " + this.getShorthand());
                ((Suspendable)this.getInstance()).resume();
            }
            catch (Exception e) {
                String msg = "Resuming the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
            }
        }
    }

    public void suspend() {
        if (this.instance instanceof Suspendable) {
            try {
                this.getLogger().debug("Suspendable.suspend() for " + this.getShorthand());
                ((Suspendable)this.getInstance()).suspend();
            }
            catch (Exception e) {
                String msg = "Suspending the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
            }
        }
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        this.notNull(configuration, "configuration");
        if (this.instance instanceof Reconfigurable) {
            try {
                this.getLogger().debug("Reconfigurable.reconfigure() for " + this.getShorthand());
                String shorthand = this.getShorthand();
                Configuration componentConfiguraton = configuration.getChild(shorthand);
                ((Reconfigurable)this.getInstance()).reconfigure(componentConfiguraton);
            }
            catch (Exception e) {
                String msg = "Reconfiguring the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.instance instanceof Disposable) {
            try {
                this.getLogger().debug("Disposable.dispose() for " + this.getShorthand());
                ((Disposable)this.getInstance()).dispose();
                this.instance = null;
            }
            catch (Exception e) {
                String msg = "Disposing the following service failed : " + this.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
            }
        }
    }

    public boolean isInstantiated() {
        return this.instance != null;
    }

    public boolean isEarlyInit() {
        return this.isEarlyInit;
    }

    public Object getInstance() throws InstantiationException, IllegalAccessException {
        if (this.isInstantiated()) {
            return this.instance;
        }
        return this.create();
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShorthand() {
        return this.shorthand;
    }

    public void setShorthand(String shorthand) {
        this.shorthand = shorthand;
    }

    private void notNull(Object object, String name) {
        if (object == null) {
            throw new NullPointerException(name);
        }
    }
}

