/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.container;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.fulcrum.yaafi.framework.container.ServiceComponent;
import org.apache.fulcrum.yaafi.framework.container.ServiceComponentImpl;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;

public class ServiceContainerImpl
implements ServiceContainer {
    private String componentRolesLocation = "/componentRoles.xml";
    private String componentConfigurationLocation = "/componentConfiguration.xml";
    private String parametersLocation = "/parameters.properties";
    private File applicationRootDir = new File(new File("").getAbsolutePath());
    private File tempRootDir = new File(System.getProperty("java.io.tmpdir", "."));
    private Logger logger;
    private List serviceList = new ArrayList();
    private Hashtable serviceMap = new Hashtable();
    private Configuration roleConfiguration;
    private Configuration serviceConfiguration;
    private Context context;
    private Parameters parameters;
    private boolean isDisposed = false;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.setComponentRolesLocation(configuration.getChild("componentRoles").getValue("/componentRoles.xml"));
        this.setComponentConfigurationLocation(configuration.getChild("componentConfiguration").getValue("/componentConfiguration.xml"));
        this.setParametersLocation(configuration.getChild("parameters").getValue("/parameters.properties"));
    }

    public void initialize() throws Exception {
        this.getLogger().debug("Service Framework is starting up");
        this.getLogger().debug("Using the following applicationRootDir : " + this.applicationRootDir.getAbsolutePath());
        this.getLogger().debug("Using the following tempRootDir : " + this.tempRootDir.getAbsolutePath());
        this.serviceConfiguration = this.loadConfiguration(this.componentConfigurationLocation);
        this.roleConfiguration = this.loadConfiguration(this.componentRolesLocation);
        if (this.roleConfiguration == null) {
            String msg = "Unable to locate the role configuration : " + this.componentRolesLocation;
            this.getLogger().error(msg);
            throw new ConfigurationException(msg);
        }
        if (this.context == null) {
            this.getLogger().debug("Creating a DefaultContext");
            this.context = this.createDefaultContext();
        }
        if (this.parameters == null) {
            this.parameters = this.loadParameters(this.parametersLocation);
        }
        List currServiceList = this.createServiceComponents(this.roleConfiguration, this.logger);
        this.setServiceList(currServiceList);
        int i = 0;
        while (i < this.serviceList.size()) {
            ServiceComponent serviceComponent = (ServiceComponent)this.serviceList.get(i);
            this.serviceMap.put(serviceComponent.getName(), serviceComponent);
            ++i;
        }
        this.incarnate(this.serviceList);
        this.isDisposed = false;
        this.getLogger().debug("Service Framework is up and running");
    }

    public void contextualize(Context context) throws ContextException {
        Object entry = null;
        File currApplicationRootDir = null;
        File currTempRootDir = null;
        this.context = context;
        if (this.isInContext(context, "urn:avalon:home")) {
            entry = context.get((Object)"urn:avalon:home");
            if (entry instanceof String) {
                String dirName = (String)entry;
                currApplicationRootDir = dirName.length() == 0 ? new File(new File(dirName).getAbsolutePath()) : new File(dirName);
            }
            if (entry instanceof File) {
                currApplicationRootDir = (File)context.get((Object)"urn:avalon:home");
            }
        }
        if (currApplicationRootDir != null) {
            this.setApplicationRootDir(currApplicationRootDir);
        }
        if (this.isInContext(context, "urn:avalon:temp")) {
            entry = context.get((Object)"urn:avalon:temp");
            if (entry instanceof String) {
                currTempRootDir = new File((String)entry);
            }
            if (entry instanceof File) {
                currTempRootDir = (File)context.get((Object)"urn:avalon:temp");
            }
        }
        if (currTempRootDir != null) {
            this.setTempRootDir(currTempRootDir);
        }
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.getLogger().info("Disposing all services");
        this.decommision(this.getServiceList());
        this.serviceList.clear();
        this.serviceMap.clear();
        this.componentRolesLocation = null;
        this.componentConfigurationLocation = null;
        this.context = null;
        this.parametersLocation = null;
        this.roleConfiguration = null;
        this.serviceConfiguration = null;
        this.parameters = null;
        this.isDisposed = true;
        this.getLogger().debug("All services are disposed");
    }

    public synchronized void reconfigure(Configuration configuration) throws ConfigurationException {
        ServiceComponent serviceComponent = null;
        this.getLogger().info("Reconfiguring all services");
        int i = this.getServiceList().size() - 1;
        while (i >= 0) {
            serviceComponent = (ServiceComponent)this.getServiceList().get(i);
            serviceComponent.suspend();
            --i;
        }
        i = 0;
        while (i < this.getServiceList().size()) {
            serviceComponent = (ServiceComponent)this.getServiceList().get(i);
            serviceComponent.reconfigure(this.getServiceConfiguration());
            ++i;
        }
        i = 0;
        while (i < this.getServiceList().size()) {
            serviceComponent = (ServiceComponent)this.getServiceList().get(i);
            serviceComponent.resume();
            ++i;
        }
    }

    public synchronized boolean hasService(String name) {
        ServiceComponent serviceComponent = (ServiceComponent)this.getServiceMap().get(name);
        return serviceComponent != null;
    }

    public synchronized Object lookup(String name) throws ServiceException {
        Object result = null;
        ServiceComponent serviceComponent = null;
        serviceComponent = (ServiceComponent)this.getServiceMap().get(name);
        if (serviceComponent != null) {
            try {
                if (serviceComponent.isInstantiated()) {
                    result = serviceComponent.getInstance();
                } else {
                    result = serviceComponent.create();
                    this.incarnate(serviceComponent);
                }
            }
            catch (Exception e) {
                String msg = "Failed to lookup the service " + serviceComponent.getShorthand();
                this.getLogger().error(msg, (Throwable)e);
                throw new ServiceException(serviceComponent.getShorthand(), msg, (Throwable)e);
            }
        }
        if (result == null) {
            String msg = "Service not found : " + name;
            this.getLogger().error(msg);
            throw new ServiceException(name, msg);
        }
        return result;
    }

    public synchronized void release(Object arg0) {
    }

    protected void setComponentConfigurationLocation(String string) {
        this.componentConfigurationLocation = string;
    }

    protected void setComponentRolesLocation(String string) {
        this.componentRolesLocation = string;
    }

    protected void setParametersLocation(String string) {
        this.parametersLocation = string;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Hashtable getServiceMap() {
        return this.serviceMap;
    }

    protected void incarnate(ServiceComponent serviceComponent) throws ContextException, ServiceException, ConfigurationException, ParameterException, Exception {
        this.getLogger().debug("Incarnating the service " + serviceComponent.getShorthand());
        serviceComponent.enableLogging(this.getLogger());
        serviceComponent.contextualize(this.context);
        serviceComponent.service(this);
        serviceComponent.configure(this.getServiceConfiguration());
        serviceComponent.parameterize(this.parameters);
        serviceComponent.initialize();
        serviceComponent.execute();
        serviceComponent.start();
    }

    protected void decommision(ServiceComponent serviceComponent) {
        String msg;
        this.getLogger().debug("Decommisioning the service " + serviceComponent.getShorthand());
        try {
            serviceComponent.stop();
        }
        catch (Throwable e) {
            msg = "Stopping the following service failed : " + serviceComponent.getName();
            this.getLogger().error(msg, e);
        }
        try {
            serviceComponent.dispose();
        }
        catch (Throwable e) {
            msg = "Disposing the following service failed : " + serviceComponent.getName();
            this.getLogger().error(msg, e);
        }
    }

    private void incarnate(List serviceList) throws ContextException, ServiceException, ConfigurationException, ParameterException, Exception {
        ServiceComponent serviceComponent = null;
        int i = 0;
        while (i < serviceList.size()) {
            serviceComponent = (ServiceComponent)this.serviceList.get(i);
            this.incarnate(serviceComponent);
            ++i;
        }
    }

    private void decommision(List serviceList) {
        ServiceComponent serviceComponent = null;
        int i = serviceList.size() - 1;
        while (i >= 0) {
            serviceComponent = (ServiceComponent)this.getServiceList().get(i);
            this.decommision(serviceComponent);
            --i;
        }
    }

    private List getServiceList() {
        return this.serviceList;
    }

    private void setServiceList(List list) {
        this.serviceList = list;
    }

    private Configuration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    private List createServiceComponents(Configuration roleConfiguration, Logger logger) throws ConfigurationException {
        if (roleConfiguration == null) {
            String msg = "The roleConfiguration is <null>";
            throw new ConfigurationException(msg);
        }
        ArrayList<ServiceComponentImpl> result = new ArrayList<ServiceComponentImpl>();
        Configuration[] roleListEntries = this.getRoleConfigurationList(roleConfiguration);
        ServiceComponentImpl serviceComponent = null;
        int i = 0;
        while (i < roleListEntries.length) {
            try {
                serviceComponent = new ServiceComponentImpl(roleListEntries[i], logger);
                if (serviceComponent.isEarlyInit()) {
                    serviceComponent.loadClass();
                    serviceComponent.create();
                } else {
                    serviceComponent.loadClass();
                }
                result.add(serviceComponent);
            }
            catch (Throwable t) {
                String msg = "Failed to load the service " + serviceComponent.getName();
                this.getLogger().error(msg, t);
                throw new ConfigurationException(msg, t);
            }
            ++i;
        }
        return result;
    }

    private Configuration loadConfiguration(String location) throws Exception {
        Configuration result = null;
        InputStream is = this.getInputStream(location);
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        if (is != null) {
            result = builder.build(is);
        }
        return result;
    }

    private Parameters loadParameters(String location) throws Exception {
        InputStream is = this.getInputStream(location);
        Configuration conf = null;
        Parameters result = new Parameters();
        if (is != null) {
            if (location.endsWith(".xml")) {
                result = Parameters.fromConfiguration(conf);
            } else {
                Properties props = new Properties();
                props.load(is);
                result = Parameters.fromProperties((Properties)props);
            }
        }
        return result;
    }

    private InputStream getInputStream(String location) throws Exception {
        if (location == null || location.length() == 0) {
            return null;
        }
        File file = null;
        InputStream is = null;
        if (is == null && !location.startsWith("/")) {
            file = new File(this.applicationRootDir, location);
            this.getLogger().debug("Looking for " + location + " in the application directory");
            if (file.exists()) {
                is = new FileInputStream(file);
            }
        }
        if (is == null) {
            file = new File(location);
            this.getLogger().debug("Looking for " + location + " as absolute file location");
            if (file.isAbsolute() && file.exists()) {
                is = new FileInputStream(file);
            }
        }
        if (is == null && location.startsWith("/")) {
            this.getLogger().debug("Looking for " + location + " using the class loader");
            is = this.getClass().getResourceAsStream(location);
        }
        if (is == null) {
            this.getLogger().warn("Unable to locate " + location);
        } else {
            this.getLogger().debug("Successfully located " + location);
        }
        return is;
    }

    private Configuration[] getRoleConfigurationList(Configuration roleConfiguration) {
        Configuration[] result = null;
        ArrayList<Configuration> roleListEntries = new ArrayList<Configuration>();
        String rootElementName = roleConfiguration.getName();
        if (rootElementName.equals("role-list")) {
            roleListEntries.addAll(Arrays.asList(roleConfiguration.getChildren()));
        } else if (rootElementName.equals("container")) {
            Configuration[] temp = roleConfiguration.getChildren();
            int i = 0;
            while (i < temp.length) {
                if (temp[i].getName().equals("component")) {
                    roleListEntries.add(temp[i]);
                }
                ++i;
            }
        } else {
            throw new RuntimeException("Don't know how to parse the roleConfiguration");
        }
        result = roleListEntries.toArray(new Configuration[roleListEntries.size()]);
        return result;
    }

    private DefaultContext createDefaultContext() {
        DefaultContext result = new DefaultContext();
        result.put((Object)"urn:avalon:home", (Object)this.applicationRootDir);
        result.put((Object)"urn:avalon:temp", (Object)this.tempRootDir);
        result.put((Object)"componentAppRoot", (Object)this.applicationRootDir.getAbsolutePath());
        return result;
    }

    private boolean isInContext(Context context, String name) {
        if (context == null) {
            return false;
        }
        try {
            return context.get((Object)name) != null;
        }
        catch (ContextException e) {
            return false;
        }
    }

    private void setApplicationRootDir(File dir) {
        if (dir == null) {
            String msg = "The applicationRootDir is <null>";
            throw new IllegalArgumentException(msg);
        }
        if (!dir.exists()) {
            String msg = "The applicatonRootDir " + dir.getAbsolutePath() + " does not exist";
            throw new IllegalArgumentException(msg);
        }
        this.getLogger().debug("Setting applicationRootDir to " + dir.getAbsolutePath());
        this.applicationRootDir = dir;
    }

    public void setTempRootDir(File dir) {
        if (dir == null) {
            String msg = "The tempRootDir is <null>";
            throw new IllegalArgumentException(msg);
        }
        if (!dir.exists()) {
            String msg = "The tempRootDir " + dir.getAbsolutePath() + " does not exist";
            throw new IllegalArgumentException(msg);
        }
        this.getLogger().debug("Setting tempRootDir to " + dir.getAbsolutePath());
        this.tempRootDir = dir;
    }
}

