/*
 * Decompiled with CFR 0.152.
 */
package fun.feellmoose.enums;

import java.net.URI;
import java.net.URISyntaxException;

public enum SastLinkApi {
    AUTHORIZE("OAUTH\u8ba4\u8bc1", "/oauth2/authorize"),
    VERIFY_ACCOUNT("\u9a8c\u8bc1\u8d26\u53f7", "/verify/account"),
    LOGIN("\u767b\u5f55", "/user/login"),
    ACCESS_TOKEN("\u83b7\u53d6ACCESS_TOKEN", "/oauth2/token"),
    REFRESH("\u5237\u65b0ACCESS_TOKEN", "/oauth2/refresh"),
    USER_INFO("\u83b7\u53d6\u7528\u6237\u4fe1\u606f", "/oauth2/userinfo");

    private final String description;
    private final String url;

    private SastLinkApi(String description, String url) {
        this.description = description;
        this.url = url;
    }

    public String getHttp(String hostName) {
        return "https://" + hostName + this.url;
    }

    public URI getHttpURI(String hostName) {
        try {
            return new URI(this.getHttp(hostName));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }
}

