/*
 * Decompiled with CFR 0.152.
 */
package fun.feellmoose.exception;

import fun.feellmoose.enums.SastLinkErrorEnum;
import fun.feellmoose.model.response.SastLinkResponse;
import fun.feellmoose.util.JsonUtil;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SastLinkException
extends RuntimeException {
    private final SastLinkErrorEnum errorEnum;

    public SastLinkException(String message) {
        super(message);
        this.errorEnum = SastLinkErrorEnum.COMMON_ERROR;
    }

    public SastLinkException(SastLinkResponse<?> response) {
        super(SastLinkException.getErrorMessage(response));
        this.errorEnum = SastLinkErrorEnum.COMMON_ERROR;
    }

    public SastLinkException(@Nullable SastLinkErrorEnum errorEnum) {
        super(SastLinkException.getErrorMessage(errorEnum, null));
        this.errorEnum = Optional.ofNullable(errorEnum).orElse(SastLinkErrorEnum.COMMON_ERROR);
    }

    public SastLinkException(Throwable throwable) {
        super(SastLinkException.getErrorMessage(SastLinkErrorEnum.COMMON_ERROR, throwable));
        this.errorEnum = SastLinkErrorEnum.COMMON_ERROR;
    }

    public SastLinkException(@Nullable SastLinkErrorEnum errorEnum, @Nullable Throwable throwable) {
        super(SastLinkException.getErrorMessage(errorEnum, throwable));
        this.errorEnum = Optional.ofNullable(errorEnum).orElse(SastLinkErrorEnum.COMMON_ERROR);
    }

    private static String getErrorMessage(@Nullable SastLinkErrorEnum errorEnum, @Nullable Throwable throwable) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (errorEnum == null) {
            errorEnum = SastLinkErrorEnum.COMMON_ERROR;
        }
        errorMessageBuilder.append("sast-link-sdk error message: ").append(errorEnum.getMessage());
        if (throwable != null) {
            String msg = throwable.getMessage();
            if (msg == null) {
                msg = "";
            }
            if (msg.contains("Bad Request:")) {
                SastLinkResponse sastLinkResponse = JsonUtil.fromJson(msg.substring(msg.indexOf("Bad Request:") + 14, msg.length() - 1), SastLinkResponse.class);
                errorMessageBuilder.append(" Exception: Bad Request: sast-link error ErrCode: ").append(sastLinkResponse.getErrCode()).append(", ErrMsg:").append(sastLinkResponse.getErrMsg());
            }
        }
        return errorMessageBuilder.toString();
    }

    private static String getErrorMessage(@NotNull SastLinkResponse<?> response) {
        if (response.isSuccess()) {
            return "logic error, message needs to be handled successfully: " + String.valueOf(response);
        }
        return "Exception: sast-link error RESPONSE: ErrCode: " + response.getErrCode() + ", ErrMsg:" + response.getErrMsg();
    }

    public SastLinkErrorEnum getErrorEnum() {
        return this.errorEnum;
    }
}

