/*
 * Decompiled with CFR 0.152.
 */
package fun.feellmoose.service.impl;

import fun.feellmoose.constants.LinkParamConstants;
import fun.feellmoose.exception.SastLinkException;
import fun.feellmoose.service.SastLinkService;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractSastLinkService
implements SastLinkService,
LinkParamConstants {
    protected final String client_id;
    protected final String client_secret;
    protected final String code_verifier;
    protected final String redirect_uri;
    protected final String host_name;

    protected AbstractSastLinkService(Builder<? extends SastLinkService.Builder<?>> builder) {
        this.client_id = builder.client_id;
        this.client_secret = builder.client_secret;
        this.code_verifier = builder.code_verifier;
        this.redirect_uri = builder.redirect_uri;
        this.host_name = builder.host_name;
    }

    public static abstract class Builder<B extends Builder<B>>
    implements SastLinkService.Builder<B> {
        protected String client_id;
        protected String client_secret;
        protected String code_verifier;
        protected String redirect_uri;
        protected String host_name;

        public B setClientId(String client_id) {
            ((Builder)this.self()).client_id = client_id;
            return this.self();
        }

        public B setClientSecret(String client_secret) {
            ((Builder)this.self()).client_secret = client_secret;
            return this.self();
        }

        @Deprecated
        public B setCodeVerifier(String code_verifier) {
            ((Builder)this.self()).code_verifier = code_verifier;
            return this.self();
        }

        @Deprecated
        public B setRedirectUri(String redirect_uri) {
            ((Builder)this.self()).redirect_uri = redirect_uri;
            return this.self();
        }

        public B setHostName(String host_name) {
            ((Builder)this.self()).host_name = host_name;
            return this.self();
        }

        protected abstract B self();

        @Override
        public SastLinkService build() {
            if (this.client_id.isEmpty() || this.client_secret.isEmpty()) {
                throw new SastLinkException("redirect_uri, client_id or client_secret not exist");
            }
            if (this.host_name.isEmpty()) {
                throw new SastLinkException("sast-link server host_name is needed in building a sastLinkService");
            }
            return null;
        }
    }
}

