/*
 * Decompiled with CFR 0.152.
 */
package fun.feellmoose.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import fun.feellmoose.enums.GrantType;
import fun.feellmoose.enums.SastLinkApi;
import fun.feellmoose.enums.SastLinkErrorEnum;
import fun.feellmoose.exception.SastLinkException;
import fun.feellmoose.model.response.SastLinkResponse;
import fun.feellmoose.model.response.data.AccessToken;
import fun.feellmoose.model.response.data.RefreshToken;
import fun.feellmoose.model.response.data.User;
import fun.feellmoose.service.SastLinkService;
import fun.feellmoose.service.impl.AbstractSastLinkService;
import fun.feellmoose.util.JsonUtil;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class HttpClientSastLinkService
extends AbstractSastLinkService {
    private final HttpClient httpClient;

    private HttpClientSastLinkService(Builder builder) {
        super(builder);
        this.httpClient = builder.httpClient;
    }

    @Override
    public AccessToken accessToken(String code) throws SastLinkException {
        AccessToken accessToken;
        if (this.code_verifier == null) {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        if (this.redirect_uri == null) {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        Map<Object, Object> data = Map.of("code", code, "code_verifier", this.code_verifier, "grant_type", GrantType.AUTHORIZATION_CODE.name, "redirect_uri", this.redirect_uri, "client_id", this.client_id, "client_secret", this.client_secret);
        HttpRequest request = HttpRequest.newBuilder(SastLinkApi.ACCESS_TOKEN.getHttpURI(this.host_name)).header("Content-Type", "multipart/form-data;boundary=" + boundary).POST(HttpClientSastLinkService.ofMimeMultipartData(data)).build();
        try {
            accessToken = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body().transform(body -> {
                if (body.isEmpty()) {
                    throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
                }
                SastLinkResponse<AccessToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<AccessToken>>(){});
                if (!response.isSuccess()) {
                    throw new SastLinkException(response);
                }
                return response.getData();
            });
        }
        catch (IOException e) {
            throw new SastLinkException(SastLinkErrorEnum.IO_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SastLinkException(e);
        }
        return accessToken;
    }

    @Override
    public AccessToken accessToken(String code, String redirectURI, String codeVerifier) throws SastLinkException {
        AccessToken accessToken;
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        if (codeVerifier != null) {
            data.put("code_verifier", codeVerifier);
        }
        if (redirectURI != null) {
            data.put("redirect_uri", redirectURI);
        } else if (this.redirect_uri != null) {
            data.put("redirect_uri", this.redirect_uri);
        } else {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        data.put("code", code);
        data.put("grant_type", GrantType.AUTHORIZATION_CODE.name);
        data.put("client_id", this.client_id);
        data.put("client_secret", this.client_secret);
        HttpRequest request = HttpRequest.newBuilder(SastLinkApi.ACCESS_TOKEN.getHttpURI(this.host_name)).header("Content-Type", "multipart/form-data;boundary=" + boundary).POST(HttpClientSastLinkService.ofMimeMultipartData(data)).build();
        try {
            accessToken = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body().transform(body -> {
                if (body.isEmpty()) {
                    throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
                }
                SastLinkResponse<AccessToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<AccessToken>>(){});
                if (!response.isSuccess()) {
                    throw new SastLinkException(response);
                }
                return response.getData();
            });
        }
        catch (IOException e) {
            throw new SastLinkException(SastLinkErrorEnum.IO_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SastLinkException(e);
        }
        return accessToken;
    }

    @Override
    public RefreshToken refreshToken(String refreshToken) throws SastLinkException {
        RefreshToken refresh;
        Map<Object, Object> data = Map.of("refresh_token", refreshToken, "grant_type", GrantType.REFRESH_TOKEN.name);
        HttpRequest request = HttpRequest.newBuilder(SastLinkApi.REFRESH.getHttpURI(this.host_name)).header("Content-Type", "multipart/form-data;boundary=" + boundary).POST(HttpClientSastLinkService.ofMimeMultipartData(data)).build();
        try {
            refresh = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body().transform(body -> {
                if (body.isEmpty()) {
                    throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
                }
                SastLinkResponse<RefreshToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<RefreshToken>>(){});
                if (!response.isSuccess()) {
                    throw new SastLinkException(response);
                }
                return response.getData();
            });
        }
        catch (IOException e) {
            throw new SastLinkException(SastLinkErrorEnum.IO_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SastLinkException(e);
        }
        return refresh;
    }

    @Override
    public User user(String accessToken) throws SastLinkException {
        User user;
        HttpRequest request = HttpRequest.newBuilder(SastLinkApi.USER_INFO.getHttpURI(this.host_name)).header("Authorization", "Bearer " + accessToken).GET().build();
        try {
            user = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body().transform(body -> {
                if (body.isEmpty()) {
                    throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
                }
                SastLinkResponse<User> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<User>>(){});
                if (!response.isSuccess()) {
                    throw new SastLinkException(response);
                }
                return response.getData();
            });
        }
        catch (IOException e) {
            throw new SastLinkException(SastLinkErrorEnum.IO_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SastLinkException(e);
        }
        return user;
    }

    public static HttpRequest.BodyPublisher ofMimeMultipartData(Map<Object, Object> data) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byte[] separator = ("--" + boundary + "\r\nContent-Disposition: form-data; name=").getBytes(StandardCharsets.UTF_8);
        try {
            for (Map.Entry<Object, Object> entry : data.entrySet()) {
                byteArrays.add(separator);
                if (entry.getValue() instanceof Path) {
                    Path path = (Path)entry.getValue();
                    String mimeType = Files.probeContentType(path);
                    byteArrays.add(("\"" + String.valueOf(entry.getKey()) + "\"; filename=\"" + String.valueOf(path.getFileName()) + "\"\r\nContent-Type: " + mimeType + "\r\n\r\n").getBytes(StandardCharsets.UTF_8));
                    byteArrays.add(Files.readAllBytes(path));
                    byteArrays.add("\r\n".getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                byteArrays.add(("\"" + String.valueOf(entry.getKey()) + "\"\r\n\r\n" + String.valueOf(entry.getValue()) + "\r\n").getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byteArrays.add(("--" + boundary + "--").getBytes(StandardCharsets.UTF_8));
        return HttpRequest.BodyPublishers.ofByteArrays(byteArrays);
    }

    public static class Builder
    extends AbstractSastLinkService.Builder<Builder> {
        private HttpClient httpClient;

        public Builder setHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SastLinkService build() {
            super.build();
            if (this.httpClient == null) {
                this.httpClient = HttpClient.newHttpClient();
            }
            return new HttpClientSastLinkService(this);
        }
    }
}

