/*
 * Decompiled with CFR 0.152.
 */
package fun.feellmoose.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import fun.feellmoose.enums.GrantType;
import fun.feellmoose.enums.SastLinkApi;
import fun.feellmoose.enums.SastLinkErrorEnum;
import fun.feellmoose.exception.SastLinkException;
import fun.feellmoose.model.response.SastLinkResponse;
import fun.feellmoose.model.response.data.AccessToken;
import fun.feellmoose.model.response.data.RefreshToken;
import fun.feellmoose.model.response.data.User;
import fun.feellmoose.service.SastLinkService;
import fun.feellmoose.service.impl.AbstractSastLinkService;
import fun.feellmoose.util.JsonUtil;
import java.io.IOException;
import java.net.URI;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public final class OkHttpSastLinkService
extends AbstractSastLinkService {
    private final OkHttpClient okHttpClient;

    private OkHttpSastLinkService(Builder builder) {
        super(builder);
        this.okHttpClient = builder.okHttpClient;
    }

    @Override
    public AccessToken accessToken(String code) throws SastLinkException {
        if (this.code_verifier == null) {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        if (this.redirect_uri == null) {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        HttpUrl url = HttpUrl.get((URI)SastLinkApi.ACCESS_TOKEN.getHttpURI(this.host_name));
        FormBody formBody = new FormBody.Builder().add("code", code).add("code_verifier", this.code_verifier).add("grant_type", GrantType.AUTHORIZATION_CODE.name).add("redirect_uri", this.redirect_uri).add("client_id", this.client_id).add("client_secret", this.client_secret).build();
        Request request = new Request.Builder().header("Content-Type", "multipart/form-data").url(url).method("POST", (RequestBody)formBody).build();
        String body = this.exchangeForResponseBody(request);
        SastLinkResponse<AccessToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<AccessToken>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    @Override
    public AccessToken accessToken(String code, String redirectURI, String codeVerifier) throws SastLinkException {
        HttpUrl url = HttpUrl.get((URI)SastLinkApi.ACCESS_TOKEN.getHttpURI(this.host_name));
        FormBody.Builder builder = new FormBody.Builder();
        if (codeVerifier != null) {
            builder.add("code_verifier", codeVerifier);
        }
        if (redirectURI != null) {
            builder.add("redirect_uri", redirectURI);
        } else if (this.redirect_uri != null) {
            builder.add("redirect_uri", this.redirect_uri);
        } else {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        builder.add("code", code).add("grant_type", GrantType.AUTHORIZATION_CODE.name).add("client_id", this.client_id).add("client_secret", this.client_secret).build();
        FormBody formBody = builder.build();
        Request request = new Request.Builder().header("Content-Type", "multipart/form-data").url(url).method("POST", (RequestBody)formBody).build();
        String body = this.exchangeForResponseBody(request);
        SastLinkResponse<AccessToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<AccessToken>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    @Override
    public RefreshToken refreshToken(String refreshToken) throws SastLinkException {
        HttpUrl url = HttpUrl.get((URI)SastLinkApi.REFRESH.getHttpURI(this.host_name));
        FormBody formBody = new FormBody.Builder().add("refresh_token", refreshToken).add("grant_type", GrantType.REFRESH_TOKEN.name).build();
        Request request = new Request.Builder().header("Content-Type", "multipart/form-data").url(url).method("POST", (RequestBody)formBody).build();
        String body = this.exchangeForResponseBody(request);
        SastLinkResponse<RefreshToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<RefreshToken>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    @Override
    public User user(String accessToken) throws SastLinkException {
        HttpUrl url = HttpUrl.get((URI)SastLinkApi.USER_INFO.getHttpURI(this.host_name));
        Request request = new Request.Builder().header("Authorization", "Bearer " + accessToken).url(url).get().build();
        String body = this.exchangeForResponseBody(request);
        SastLinkResponse<User> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<User>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    private String exchangeForResponseBody(Request request) {
        String body;
        try {
            ResponseBody responseBody = this.okHttpClient.newCall(request).execute().body();
            if (responseBody == null) {
                throw new SastLinkException(SastLinkErrorEnum.NULL_RESPONSE_BODY);
            }
            body = responseBody.string();
            if (body.isEmpty()) {
                throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
            }
        }
        catch (IOException e) {
            throw new SastLinkException(SastLinkErrorEnum.IO_ERROR, (Throwable)e);
        }
        return body;
    }

    public static class Builder
    extends AbstractSastLinkService.Builder<Builder> {
        private OkHttpClient okHttpClient;

        public Builder setOkHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SastLinkService build() {
            super.build();
            if (this.okHttpClient == null) {
                this.okHttpClient = new OkHttpClient();
            }
            return new OkHttpSastLinkService(this);
        }
    }
}

