/*
 * Decompiled with CFR 0.152.
 */
package fun.feellmoose.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import fun.feellmoose.enums.GrantType;
import fun.feellmoose.enums.SastLinkApi;
import fun.feellmoose.enums.SastLinkErrorEnum;
import fun.feellmoose.exception.SastLinkException;
import fun.feellmoose.model.response.SastLinkResponse;
import fun.feellmoose.model.response.data.AccessToken;
import fun.feellmoose.model.response.data.RefreshToken;
import fun.feellmoose.model.response.data.User;
import fun.feellmoose.service.SastLinkService;
import fun.feellmoose.service.impl.AbstractSastLinkService;
import fun.feellmoose.util.JsonUtil;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public final class RestTemplateSastLinkService
extends AbstractSastLinkService {
    private final RestTemplate restTemplate;

    private RestTemplateSastLinkService(Builder builder) {
        super(builder);
        this.restTemplate = builder.restTemplate;
    }

    @Override
    public AccessToken accessToken(String code) throws SastLinkException {
        if (this.code_verifier == null) {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        if (this.redirect_uri == null) {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"code", (Object)code);
        map.add((Object)"code_verifier", (Object)this.code_verifier);
        map.add((Object)"grant_type", (Object)GrantType.AUTHORIZATION_CODE.name);
        map.add((Object)"redirect_uri", (Object)this.redirect_uri);
        map.add((Object)"client_id", (Object)this.client_id);
        map.add((Object)"client_secret", (Object)this.client_secret);
        RequestEntity entity = ((RequestEntity.BodyBuilder)RequestEntity.post((String)SastLinkApi.ACCESS_TOKEN.getHttp(this.host_name), (Object[])new Object[0]).header("Content-Type", new String[]{"multipart/form-data"})).body((Object)map);
        String body = (String)this.restTemplate.exchange(entity, String.class).getBody();
        if (body == null) {
            throw new SastLinkException(SastLinkErrorEnum.NULL_RESPONSE_BODY);
        }
        if (body.isEmpty()) {
            throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
        }
        SastLinkResponse<AccessToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<AccessToken>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    @Override
    public AccessToken accessToken(String code, String redirectURI, String codeVerifier) throws SastLinkException {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        if (codeVerifier != null) {
            map.add((Object)"code_verifier", (Object)codeVerifier);
        }
        if (redirectURI != null) {
            map.add((Object)"redirect_uri", (Object)redirectURI);
        } else if (this.redirect_uri != null) {
            map.add((Object)"redirect_uri", (Object)this.redirect_uri);
        } else {
            throw new SastLinkException("Get AccessToken by params(code) with no default verifier is not allowed");
        }
        map.add((Object)"code", (Object)code);
        map.add((Object)"grant_type", (Object)GrantType.AUTHORIZATION_CODE.name);
        map.add((Object)"client_id", (Object)this.client_id);
        map.add((Object)"client_secret", (Object)this.client_secret);
        RequestEntity entity = ((RequestEntity.BodyBuilder)RequestEntity.post((String)SastLinkApi.ACCESS_TOKEN.getHttp(this.host_name), (Object[])new Object[0]).header("Content-Type", new String[]{"multipart/form-data"})).body((Object)map);
        String body = (String)this.restTemplate.exchange(entity, String.class).getBody();
        if (body == null) {
            throw new SastLinkException(SastLinkErrorEnum.NULL_RESPONSE_BODY);
        }
        if (body.isEmpty()) {
            throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
        }
        SastLinkResponse<AccessToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<AccessToken>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    @Override
    public RefreshToken refreshToken(String refreshToken) throws SastLinkException {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"refresh_token", (Object)refreshToken);
        map.add((Object)"grant_type", (Object)GrantType.REFRESH_TOKEN.name);
        RequestEntity entity = ((RequestEntity.BodyBuilder)RequestEntity.post((String)SastLinkApi.REFRESH.getHttp(this.host_name), (Object[])new Object[0]).header("Content-Type", new String[]{"multipart/form-data"})).body((Object)map);
        String body = (String)this.restTemplate.exchange(entity, String.class).getBody();
        if (body == null) {
            throw new SastLinkException(SastLinkErrorEnum.NULL_RESPONSE_BODY);
        }
        if (body.isEmpty()) {
            throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
        }
        SastLinkResponse<RefreshToken> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<RefreshToken>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    @Override
    public User user(String accessToken) throws SastLinkException {
        RequestEntity entity = RequestEntity.get((String)SastLinkApi.USER_INFO.getHttp(this.host_name), (Object[])new Object[0]).header("Authorization", new String[]{"Bearer " + accessToken}).build();
        String body = (String)this.restTemplate.exchange(entity, String.class).getBody();
        if (body == null) {
            throw new SastLinkException(SastLinkErrorEnum.NULL_RESPONSE_BODY);
        }
        if (body.isEmpty()) {
            throw new SastLinkException(SastLinkErrorEnum.EMPTY_RESPONSE_BODY);
        }
        SastLinkResponse<User> response = JsonUtil.fromJson(body, new TypeReference<SastLinkResponse<User>>(){});
        if (!response.isSuccess()) {
            throw new SastLinkException(response);
        }
        return response.getData();
    }

    public static class Builder
    extends AbstractSastLinkService.Builder<Builder> {
        private RestTemplate restTemplate;

        public Builder setRestTemplate(RestTemplate restTemplate) {
            this.restTemplate = restTemplate;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SastLinkService build() {
            super.build();
            if (this.restTemplate == null) {
                this.restTemplate = new RestTemplate();
            }
            return new RestTemplateSastLinkService(this);
        }
    }
}

