/*
 * Decompiled with CFR 0.152.
 */
package fun.mike.dmp;

import fun.mike.dmp.Diff;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;

public class Patch {
    public LinkedList<Diff> diffs = new LinkedList();
    public int start1;
    public int start2;
    public int length1;
    public int length2;

    public String toString() {
        String coords1 = this.length1 == 0 ? this.start1 + ",0" : (this.length1 == 1 ? Integer.toString(this.start1 + 1) : this.start1 + 1 + "," + this.length1);
        String coords2 = this.length2 == 0 ? this.start2 + ",0" : (this.length2 == 1 ? Integer.toString(this.start2 + 1) : this.start2 + 1 + "," + this.length2);
        StringBuilder text = new StringBuilder();
        text.append("@@ -").append(coords1).append(" +").append(coords2).append(" @@\n");
        for (Diff aDiff : this.diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    text.append('+');
                    break;
                }
                case DELETE: {
                    text.append('-');
                    break;
                }
                case EQUAL: {
                    text.append(' ');
                }
            }
            try {
                text.append(URLEncoder.encode(aDiff.text, "UTF-8").replace('+', ' ')).append("\n");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("This system does not support UTF-8.", e);
            }
        }
        return Patch.unescapeForEncodeUriCompatability(text.toString());
    }

    private static String unescapeForEncodeUriCompatability(String str) {
        return str.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }
}

